/*
 * Decompiled with CFR 0.152.
 */
package favorites;

import favorites.VectorHash;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;

public class FileTreeNode
implements TreeNode,
Comparable,
Cloneable {
    private String name;
    private String path;
    private VectorHash children = new VectorHash();
    private boolean leaf;
    private TreeNode parent;
    public static String TYPE_FILE = "File";
    public static String TYPE_DIRECTORY = "Directory";
    private String type;

    public FileTreeNode(String name, String path, String type) {
        this.name = name;
        this.path = path.replace('\\', '/');
        this.type = type;
        this.leaf = true;
    }

    public FileTreeNode(String name, String path) {
        this(name, path, TYPE_FILE);
    }

    public FileTreeNode(String name) {
        this(name, "");
        this.leaf = false;
    }

    public boolean renameGroup(FileTreeNode node, String newname) {
        if (node.isLeaf()) {
            return false;
        }
        if (this.children.containsKey(newname)) {
            return false;
        }
        if (!this.children.containsKey(node.getKey())) {
            return false;
        }
        int index = this.children.getIndex(node.getKey());
        this.children.remove(node.getKey());
        node.setName(newname);
        this.children.insert(node.getKey(), node, index);
        return true;
    }

    public boolean addNode(FileTreeNode node) {
        if (this.children.containsKey(node.getKey())) {
            return false;
        }
        node.setParent(this);
        int index = 0;
        for (index = 0; index < this.children.size() && node.compareTo(this.children.get(index)) > 0; ++index) {
        }
        this.children.insert(node.getKey(), node, index);
        return true;
    }

    public boolean addNode(Buffer buffer) {
        return this.addNode(new FileTreeNode(buffer.getName(), buffer.getPath()));
    }

    public boolean addNode(String path, String type) {
        String name = MiscUtilities.getFileName((String)path);
        return this.addNode(new FileTreeNode(name, path, type));
    }

    public void deleteNode(FileTreeNode node) {
        if (node == null) {
            return;
        }
        this.children.remove(node.getKey());
    }

    public void setParent(FileTreeNode node) {
        this.parent = node;
    }

    public Enumeration children() {
        return this.children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.leaf;
    }

    @Override
    public TreeNode getChildAt(int index) {
        return (TreeNode)this.children.get(index);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        if (!(node instanceof FileTreeNode)) {
            return -1;
        }
        return this.children.getIndex(((FileTreeNode)node).getKey());
    }

    public TreeNode getChild(Object key) {
        return (TreeNode)this.children.get(key);
    }

    @Override
    public TreeNode getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return null;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    public String toString() {
        if (this.isLeaf()) {
            return this.name + " (" + this.path + ")";
        }
        return this.name;
    }

    public String getKey() {
        if (this.isLeaf()) {
            return this.path;
        }
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public int compareTo(Object o) {
        if (!(o instanceof FileTreeNode)) {
            return 0;
        }
        FileTreeNode node = (FileTreeNode)o;
        if (this.isLeaf() && !node.isLeaf()) {
            return 1;
        }
        if (!this.isLeaf() && node.isLeaf()) {
            return -1;
        }
        if (TYPE_DIRECTORY.equals(this.getType()) && !TYPE_DIRECTORY.equals(node.getType())) {
            return -1;
        }
        if (!TYPE_DIRECTORY.equals(this.getType()) && TYPE_DIRECTORY.equals(node.getType())) {
            return 1;
        }
        return this.toString().compareToIgnoreCase(node.toString());
    }

    public Object clone() {
        FileTreeNode clone = null;
        try {
            clone = (FileTreeNode)super.clone();
            clone.children = (VectorHash)clone.children.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clone;
    }
}

