/*
 * Decompiled with CFR 0.152.
 */
package favorites;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Vector;

public class VectorHash
implements Cloneable {
    private Vector vec = new Vector();
    private HashMap hash = new HashMap();

    public void put(Object key, Object value) {
        int index = 0;
        if (this.hash.containsKey(key)) {
            index = ((Entry)this.hash.get((Object)key)).index;
            this.vec.set(index, key);
        } else {
            index = this.vec.size();
            this.vec.add(key);
        }
        Entry e = new Entry(index, value);
        this.hash.put(key, e);
    }

    public boolean containsKey(Object key) {
        return this.hash.containsKey(key);
    }

    public Object get(Object key) {
        if (!this.hash.containsKey(key)) {
            return null;
        }
        return ((Entry)this.hash.get((Object)key)).value;
    }

    public Object get(int index) {
        Object key = this.vec.get(index);
        return this.get(key);
    }

    public Object remove(Object key) {
        if (!this.hash.containsKey(key)) {
            return null;
        }
        Entry e = (Entry)this.hash.get(key);
        this.hash.remove(key);
        this.vec.remove(e.index);
        this.reIndex(e.index);
        return e.value;
    }

    public Object remove(int index) {
        Object key = this.vec.get(index);
        return this.remove(key);
    }

    public void insert(Object key, Object value, int index) {
        this.vec.insertElementAt(key, index);
        Entry e = new Entry(index, value);
        this.hash.put(key, e);
        this.reIndex(index + 1);
    }

    private void reIndex(int index) {
        int length = this.vec.size();
        Entry e = null;
        int i = index;
        while (i < length) {
            e = (Entry)this.hash.get(this.vec.get(i));
            e.index = i++;
        }
    }

    public int size() {
        return this.vec.size();
    }

    public int getIndex(Object key) {
        if (!this.hash.containsKey(key)) {
            return -1;
        }
        return ((Entry)this.hash.get((Object)key)).index;
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;
            VectorHash hash = (VectorHash)VectorHash.this.clone();

            @Override
            public boolean hasMoreElements() {
                return this.count < this.hash.size();
            }

            public Object nextElement() {
                if (this.count < this.hash.size()) {
                    return this.hash.get(this.count++);
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        try {
            VectorHash clone = (VectorHash)super.clone();
            Vector vector = this.vec;
            synchronized (vector) {
                clone.vec = (Vector)this.vec.clone();
                clone.hash = new HashMap();
                Object key = null;
                for (int i = 0; i < this.vec.size(); ++i) {
                    key = this.vec.get(i);
                    clone.hash.put(key, ((Entry)this.hash.get(key)).clone());
                }
            }
            return clone;
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    public String toString() {
        int length = this.vec.size();
        Entry e = null;
        Object key = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            key = this.vec.get(i);
            e = (Entry)this.hash.get(key);
            sb.append(i + ":" + key + ":" + e.index + ":" + e.value);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static class Entry
    implements Cloneable {
        int index;
        Object value;

        Entry(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception e) {
                throw new InternalError();
            }
        }
    }
}

