/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.InvalidHighlightException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.BoyerMooreSearchMatcher;
import org.gjt.sp.jedit.search.PatternSearchMatcher;
import org.gjt.sp.jedit.search.SearchMatcher;

public class Highlight {
    public static final int PERMANENT_SCOPE = 0;
    public static final int SESSION_SCOPE = 1;
    public static final int BUFFER_SCOPE = 2;
    private String stringToHighlight;
    private boolean regexp;
    private boolean ignoreCase = true;
    private boolean valid;
    private SearchMatcher searchMatcher;
    private static final int HIGHLIGHT_VERSION = 1;
    private static Color defaultColor = jEdit.getColorProperty((String)"gatchan.highlight.defaultColor");
    private static final Color[] COLORS = new Color[]{new Color(153, 255, 204), new Color(102, 102, 255), new Color(255, 102, 102), new Color(255, 204, 102), new Color(204, 255, 102), new Color(255, 51, 153), new Color(255, 51, 0), new Color(102, 255, 0), new Color(153, 0, 153), new Color(153, 153, 0), new Color(0, 153, 102)};
    private static int colorIndex;
    private Color color;
    private boolean enabled = true;
    private int scope = 0;
    private JEditBuffer buffer;
    private long duration = Long.MAX_VALUE;
    private long lastSeen = System.currentTimeMillis();
    public static final String HIGHLIGHTS_BUFFER_PROPS = "highlights";

    public Highlight(String string, boolean bl, boolean bl2, int n) {
        this.scope = n;
        this.init(string, bl, bl2, Highlight.getNextColor());
    }

    public Highlight(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, 0);
    }

    public Highlight(String string) {
        this(string, false, true, 0);
    }

    public Highlight() {
    }

    public void init(String string, boolean bl, boolean bl2, Color color) {
        if (string.length() == 0) {
            this.valid = false;
            throw new IllegalArgumentException("The search string cannot be empty");
        }
        this.valid = true;
        if (bl) {
            if (this.searchMatcher == null || !string.equals(this.stringToHighlight) || !this.regexp || bl2 != this.ignoreCase) {
                this.searchMatcher = new PatternSearchMatcher(string, bl2);
            }
        } else if (this.searchMatcher == null || !string.equals(this.stringToHighlight) || this.regexp || bl2 != this.ignoreCase) {
            this.searchMatcher = new BoyerMooreSearchMatcher(string, bl2);
        }
        this.stringToHighlight = string;
        this.regexp = bl;
        this.ignoreCase = bl2;
        this.color = color;
    }

    public String getStringToHighlight() {
        return this.stringToHighlight;
    }

    public boolean isRegexp() {
        return this.regexp;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public SearchMatcher getSearchMatcher() {
        return this.searchMatcher;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean equals(Object object) {
        if (object instanceof Highlight) {
            Highlight highlight = (Highlight)object;
            return highlight.stringToHighlight.equals(this.stringToHighlight) && highlight.regexp == this.regexp && highlight.ignoreCase == this.ignoreCase;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public static void setDefaultColor(Color color) {
        defaultColor = color;
    }

    public static Color getNextColor() {
        if (defaultColor != null) {
            return defaultColor;
        }
        ++colorIndex;
        return COLORS[colorIndex %= COLORS.length];
    }

    public String serialize() {
        StringBuffer stringBuffer = new StringBuffer(this.stringToHighlight.length() + 20);
        stringBuffer.append(1).append(';');
        Highlight.serializeBoolean(stringBuffer, this.regexp);
        Highlight.serializeBoolean(stringBuffer, this.ignoreCase);
        Highlight.serializeBoolean(stringBuffer, this.enabled);
        stringBuffer.append(this.color.getRGB());
        stringBuffer.append(';');
        stringBuffer.append(this.stringToHighlight);
        return stringBuffer.toString();
    }

    private static void serializeBoolean(StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            stringBuffer.append(1);
        } else {
            stringBuffer.append(0);
        }
    }

    public static Highlight unserialize(String string, boolean bl) throws InvalidHighlightException {
        try {
            int n = string.indexOf(59);
            boolean bl2 = string.charAt(n + 1) == '1';
            boolean bl3 = string.charAt(n + 2) == '1';
            boolean bl4 = !bl || string.charAt(n + 3) == '1';
            int n2 = string.indexOf(59, n + 4);
            Color color = Color.decode(string.substring(n + 4, n2));
            String string2 = new String(string.substring(n2 + 1));
            Highlight highlight = new Highlight();
            highlight.setEnabled(bl4);
            highlight.init(string2, bl2, bl3, color);
            return highlight;
        }
        catch (Exception exception) {
            throw new InvalidHighlightException(exception);
        }
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    public JEditBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(JEditBuffer jEditBuffer) {
        List<Highlight> list;
        if (this.buffer != null) {
            list = (ArrayList<Highlight>)this.buffer.getProperty((Object)HIGHLIGHTS_BUFFER_PROPS);
            list.remove(this);
            if (list.isEmpty()) {
                this.buffer.unsetProperty(HIGHLIGHTS_BUFFER_PROPS);
            }
        }
        this.buffer = jEditBuffer;
        if (jEditBuffer != null) {
            list = (List)jEditBuffer.getProperty((Object)HIGHLIGHTS_BUFFER_PROPS);
            if (list == null) {
                list = new ArrayList<Highlight>();
                jEditBuffer.setProperty(HIGHLIGHTS_BUFFER_PROPS, list);
            }
            list.add(this);
        }
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public void updateLastSeen() {
        this.lastSeen = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.lastSeen > this.duration;
    }

    public void setStringToHighlight(String string) {
        this.init(string, this.regexp, this.ignoreCase, this.color);
    }
}

