/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightManagerTableModel;
import gatchan.highlight.HighlightTablePanel;
import gatchan.highlight.InvalidHighlightException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;

public final class HighlightCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
DocumentListener {
    private Highlight highlight;
    private final HighlightTablePanel renderer = new HighlightTablePanel();

    public HighlightCellEditor() {
        this.renderer.setCellEditor(this);
    }

    public Object getCellEditorValue() {
        return this.highlight;
    }

    public boolean stopCellEditing() {
        try {
            this.renderer.save(this.highlight);
            this.renderer.stopEdition();
            HighlightManagerTableModel.getManager().setHighlightEnable(true);
            this.fireEditingStopped();
            return true;
        }
        catch (InvalidHighlightException invalidHighlightException) {
            GUIUtilities.error((Component)jEdit.getActiveView(), (String)"gatchan-highlight.errordialog.invalidHighlight", null);
            return false;
        }
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.highlight = (Highlight)object;
        this.renderer.setHighlight(this.highlight);
        return this.renderer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.stopCellEditing();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.saveHighlight();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.saveHighlight();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.saveHighlight();
    }

    private void saveHighlight() {
        try {
            this.renderer.save(this.highlight);
            HighlightManagerTableModel.getManager().setHighlightEnable(true);
        }
        catch (InvalidHighlightException invalidHighlightException) {
            // empty catch block
        }
    }
}

