/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightManagerTableModel;
import gatchan.highlight.HighlightTablePanel;
import gatchan.highlight.InvalidHighlightException;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public final class HighlightDialog
extends EnhancedDialog {
    private final JButton ok = new JButton("ok");
    private final JButton cancel = new JButton("Cancel");
    private final Highlight highlight;
    private final HighlightTablePanel panel = new HighlightTablePanel();
    private final JComboBox scopeCombo = new JComboBox<Integer>(new Integer[]{0, 1, 2});
    private JSpinner spinner;

    public HighlightDialog(View view, Highlight highlight) {
        super((Frame)view, "Highlight", false);
        this.highlight = highlight;
        this.panel.setDialog(this);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("scope : "));
        this.scopeCombo.setRenderer(new MyListCellRenderer());
        jPanel.add(this.scopeCombo);
        this.spinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 5));
        this.spinner.setToolTipText(jEdit.getProperty((String)"gatchan.highlight.expire.tooltip"));
        MyActionListener myActionListener = new MyActionListener();
        this.ok.addActionListener(myActionListener);
        this.cancel.addActionListener(myActionListener);
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 0);
        jPanel2.setLayout(boxLayout);
        jPanel2.add(Box.createGlue());
        jPanel2.add(this.ok);
        jPanel2.add(Box.createHorizontalStrut(6));
        jPanel2.add(this.cancel);
        jPanel2.add(Box.createGlue());
        container.add(this.panel);
        container.add(jPanel);
        container.add(this.spinner);
        container.add(jPanel2);
        this.pack();
        this.setLocationRelativeTo((Component)view);
    }

    public HighlightDialog(View view) {
        this(view, new Highlight());
    }

    public void setString(String string) {
        this.panel.setString(string);
    }

    public void ok() {
        try {
            this.panel.save(this.highlight);
            long l = ((Number)this.spinner.getValue()).longValue();
            if (l != 0L) {
                this.highlight.setDuration(l * 1000L);
            }
            Integer n = (Integer)this.scopeCombo.getSelectedItem();
            int n2 = n;
            this.highlight.setScope(n2);
            if (n2 == 2) {
                Buffer buffer = jEdit.getActiveView().getBuffer();
                this.highlight.setBuffer((JEditBuffer)buffer);
            }
            HighlightManagerTableModel.getManager().addElement(this.highlight);
            this.dispose();
        }
        catch (InvalidHighlightException invalidHighlightException) {
            GUIUtilities.error((Component)jEdit.getActiveView(), (String)"gatchan-highlight.errordialog.invalidHighlight", null);
            this.panel.focus();
        }
    }

    public void cancel() {
        this.dispose();
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            int n2 = (Integer)object;
            switch (n2) {
                case 0: {
                    this.setText("permanent");
                    break;
                }
                case 1: {
                    this.setText("session");
                    break;
                }
                case 2: {
                    this.setText("buffer");
                }
            }
            return this;
        }
    }

    private final class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == HighlightDialog.this.ok) {
                HighlightDialog.this.ok();
            } else if (actionEvent.getSource() == HighlightDialog.this.cancel) {
                HighlightDialog.this.cancel();
            }
        }
    }
}

