/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.HighlightManagerTableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.HyperSearchResult;
import org.gjt.sp.jedit.search.HyperSearchResults;
import org.gjt.sp.jedit.search.SearchMatcher;

public class HighlightHypersearchResults
implements HighlightChangeListener {
    public static final String HYPERSEARCH = "hypersearch-results";
    private final View view;

    public HighlightHypersearchResults(View view) {
        this.view = view;
    }

    private JTree getHyperSearchTree() {
        JComponent jComponent = this.view.getDockableWindowManager().getDockable(HYPERSEARCH);
        if (jComponent == null) {
            return null;
        }
        if (!(jComponent instanceof HyperSearchResults)) {
            return null;
        }
        HyperSearchResults hyperSearchResults = (HyperSearchResults)jComponent;
        return hyperSearchResults.getTree();
    }

    public void start() {
        HighlightManagerTableModel.getManager().addHighlightChangeListener(this);
        JTree jTree = this.getHyperSearchTree();
        if (jTree == null) {
            return;
        }
        TreeCellRenderer treeCellRenderer = jTree.getCellRenderer();
        if (!(treeCellRenderer instanceof HighlightTreeCellRenderer)) {
            jTree.setCellRenderer(new HighlightTreeCellRenderer(treeCellRenderer));
        }
    }

    public void stop() {
        HighlightManagerTableModel.getManager().removeHighlightChangeListener(this);
        JTree jTree = this.getHyperSearchTree();
        if (jTree == null) {
            return;
        }
        TreeCellRenderer treeCellRenderer = jTree.getCellRenderer();
        if (treeCellRenderer instanceof HighlightTreeCellRenderer) {
            jTree.setCellRenderer(((HighlightTreeCellRenderer)treeCellRenderer).getOriginal());
        }
    }

    public void highlightUpdated(boolean bl) {
        JTree jTree = this.getHyperSearchTree();
        if (jTree != null) {
            jTree.repaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HighlightTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private final TreeCellRenderer renderer;

        HighlightTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
            this.renderer = treeCellRenderer;
        }

        public TreeCellRenderer getOriginal() {
            return this.renderer;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (!(object instanceof DefaultMutableTreeNode)) {
                return component;
            }
            if (!jEdit.getBooleanProperty((String)"gatchan.highlight.hyperSearchResults")) {
                return component;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (!(object2 instanceof HyperSearchResult)) {
                return component;
            }
            HyperSearchResult hyperSearchResult = (HyperSearchResult)object2;
            String string = this.getHighlightedString(hyperSearchResult.toString());
            return this.renderer.getTreeCellRendererComponent(jTree, new DefaultMutableTreeNode(string), bl, bl2, bl3, n, bl4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHighlightedString(String string) {
            int n;
            HighlightManager highlightManager = HighlightManagerTableModel.getManager();
            LinkedList<HighlightPosition> linkedList = new LinkedList<HighlightPosition>();
            try {
                highlightManager.getReadLock();
                int n2 = highlightManager.countHighlights();
                for (n = 0; n < n2; ++n) {
                    Highlight highlight = highlightManager.getHighlight(n);
                    this.addHighlight(linkedList, string, highlight);
                }
            }
            finally {
                highlightManager.releaseLock();
            }
            if (highlightManager.isHighlightWordAtCaret()) {
                this.addHighlight(linkedList, string, HighlightManagerTableModel.currentWordHighlight);
            }
            if (highlightManager.isHighlightSelection()) {
                this.addHighlight(linkedList, string, HighlightManagerTableModel.selectionHighlight);
            }
            Collections.sort(linkedList);
            StringBuilder stringBuilder = new StringBuilder("<html><body>");
            n = 0;
            for (HighlightPosition highlightPosition : linkedList) {
                this.appendString2html(stringBuilder, string.substring(n, highlightPosition.pos));
                if (highlightPosition.start) {
                    stringBuilder.append("<font style bgcolor=\"#");
                    Color color = highlightPosition.highlight.getColor();
                    stringBuilder.append(Integer.toHexString(color.getRGB()).substring(2));
                    stringBuilder.append("\">");
                } else {
                    stringBuilder.append("</font>");
                }
                n = highlightPosition.pos;
            }
            this.appendString2html(stringBuilder, string.substring(n));
            stringBuilder.append("</body></html>");
            return stringBuilder.toString();
        }

        private void addHighlight(Collection<HighlightPosition> collection, String string, Highlight highlight) {
            SearchMatcher.Match match;
            SearchMatcher searchMatcher = highlight.getSearchMatcher();
            int n = 0;
            while ((match = searchMatcher.nextMatch((CharSequence)string.substring(n), true, true, true, false)) != null) {
                collection.add(new HighlightPosition(n + match.start, highlight, true));
                collection.add(new HighlightPosition(n + match.end, highlight, false));
                n += match.end;
            }
        }

        private void appendString2html(StringBuilder stringBuilder, String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                String string2;
                char c = string.charAt(i);
                switch (c) {
                    case '\"': {
                        string2 = "&quot;";
                        break;
                    }
                    case '&': {
                        string2 = "&amp;";
                        break;
                    }
                    case '<': {
                        string2 = "&lt;";
                        break;
                    }
                    case '>': {
                        string2 = "&gt;";
                        break;
                    }
                    default: {
                        string2 = String.valueOf(c);
                    }
                }
                stringBuilder.append(string2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class HighlightPosition
        implements Comparable<HighlightPosition> {
            public int pos;
            public Highlight highlight;
            public boolean start;

            HighlightPosition(int n, Highlight highlight, boolean bl) {
                this.pos = n;
                this.highlight = highlight;
                this.start = bl;
            }

            @Override
            public int compareTo(HighlightPosition highlightPosition) {
                if (this.pos < highlightPosition.pos) {
                    return -1;
                }
                if (this.pos > highlightPosition.pos) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

