/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.Highlighter;
import gatchan.highlight.InvalidHighlightException;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class HighlightManagerTableModel
extends AbstractTableModel
implements HighlightManager {
    private static final String ENABLED_PROP = "plugin.Highlight.enabled";
    private final List<Highlight> datas = new ArrayList<Highlight>();
    private static HighlightManagerTableModel highlightManagerTableModel;
    private final List<HighlightChangeListener> highlightChangeListeners = new ArrayList<HighlightChangeListener>(2);
    private final File highlights;
    private final ReentrantReadWriteLock lock;
    public static Highlight currentWordHighlight;
    public static Highlight selectionHighlight;
    private boolean highlightWordAtCaret;
    private boolean highlightWordAtCaretEntireWord;
    private boolean highlightWordAtCaretWhitespace;
    private boolean highlightWordAtCaretOnlyWords;
    private boolean highlightSelection;
    private boolean appendHighlight = jEdit.getBooleanProperty((String)"gatchan.highlight.appendHighlight");
    public static final String FILE_VERSION = "Highlight file v2";
    private Timer timer;

    static HighlightManager createInstance(File file) {
        highlightManagerTableModel = new HighlightManagerTableModel(file);
        return highlightManagerTableModel;
    }

    public static HighlightManagerTableModel getInstance() {
        return highlightManagerTableModel;
    }

    public static HighlightManager getManager() {
        return HighlightManagerTableModel.getInstance();
    }

    private HighlightManagerTableModel(File file) {
        this.lock = new ReentrantReadWriteLock();
        this.highlights = file;
        currentWordHighlight = new Highlight();
        selectionHighlight = new Highlight();
        if (this.highlights != null && this.highlights.exists()) {
            this.loadFile(this.highlights);
        }
        this.highlightWordAtCaret = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight");
        this.highlightSelection = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight");
        this.highlightWordAtCaretEntireWord = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.entireWord");
        this.highlightWordAtCaretWhitespace = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.whitespace");
        this.highlightWordAtCaretOnlyWords = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.onlyWords");
        currentWordHighlight.init(" ", this.highlightWordAtCaretEntireWord, jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.ignoreCase"), jEdit.getColorProperty((String)"gatchan.highlight.caretHighlight.color"));
        selectionHighlight.init(" ", false, jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight.ignoreCase"), jEdit.getColorProperty((String)"gatchan.highlight.selectionHighlight.color"));
        currentWordHighlight.setEnabled(false);
        selectionHighlight.setEnabled(false);
        this.timer = new Timer(1000, new RemoveExpired());
        this.timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        try {
            this.lock.readLock().lock();
            int n = this.datas.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getColumnCount() {
        return 4;
    }

    public Class getColumnClass(int n) {
        return n == 0 ? Boolean.class : Highlight.class;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        Highlight highlight;
        try {
            this.lock.readLock().lock();
            highlight = this.datas.get(n);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (n2 == 0) {
            return highlight.isEnabled();
        }
        return highlight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            Highlight highlight;
            try {
                this.lock.readLock().lock();
                highlight = this.datas.get(n);
            }
            finally {
                this.lock.readLock().unlock();
            }
            highlight.setEnabled((Boolean)object);
        } else {
            try {
                this.lock.writeLock().lock();
                this.datas.set(n, (Highlight)object);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    public Highlight getHighlight(int n) {
        return this.datas.get(n);
    }

    public void addElement(Highlight highlight) {
        this.addElement(highlight, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addElement(Highlight highlight, boolean bl) {
        if (this.indexOf(highlight) == -1) {
            if (this.appendHighlight || this.datas.isEmpty()) {
                int n;
                try {
                    this.lock.writeLock().lock();
                    this.datas.add(highlight);
                    n = this.datas.size() - 1;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                this.fireTableRowsInserted(n, n);
            } else {
                Highlight highlight2;
                int n;
                try {
                    this.lock.readLock().lock();
                    n = this.datas.size() - 1;
                    highlight2 = this.datas.get(n);
                }
                finally {
                    this.lock.readLock().unlock();
                }
                highlight2.init(highlight.getStringToHighlight(), highlight.isRegexp(), highlight.isIgnoreCase(), highlight.getColor());
                this.fireTableRowsUpdated(n, n);
            }
        }
        if (bl) {
            this.setHighlightEnable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRow(int n) {
        try {
            this.lock.writeLock().lock();
            this.datas.remove(n);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.fireTableRowsDeleted(n, n);
    }

    private void removeRow(Highlight highlight) {
        int n = this.indexOf(highlight);
        if (n != -1) {
            this.removeRow(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int indexOf(Highlight highlight) {
        try {
            int n;
            this.lock.readLock().lock();
            int n2 = n = this.datas.indexOf(highlight);
            return n2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void bufferClosed(Buffer buffer) {
        List list = (List)buffer.getProperty((Object)"highlights");
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.removeRow((Highlight)list.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        int n;
        try {
            this.lock.writeLock().lock();
            n = this.datas.size();
            this.datas.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    public void dispose() {
        this.timer.stop();
        this.timer = null;
        highlightManagerTableModel = null;
        selectionHighlight = null;
        this.save(this.highlights);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) {
        if (file != null) {
            PrintWriter printWriter = null;
            try {
                File file2 = file.getParentFile();
                if (!file2.isDirectory()) {
                    file2.mkdirs();
                }
                printWriter = new PrintWriter(file);
                printWriter.println(FILE_VERSION);
                try {
                    this.lock.writeLock().lock();
                    ListIterator<Highlight> listIterator = this.datas.listIterator();
                    while (listIterator.hasNext()) {
                        Highlight highlight = listIterator.next();
                        if (highlight.getScope() == 0) {
                            printWriter.println(highlight.serialize());
                            continue;
                        }
                        listIterator.remove();
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                IOUtilities.closeQuietly((Writer)printWriter);
            }
            catch (IOException iOException) {
                Log.log((int)9, (Object)this, (Object)iOException);
            }
            finally {
                IOUtilities.closeQuietly(printWriter);
            }
        } else {
            Log.log((int)9, (Object)this, (Object)"No settings");
        }
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        super.fireTableChanged(tableModelEvent);
        this.fireHighlightChangeListener(this.isHighlightEnable());
    }

    public void addHighlightChangeListener(HighlightChangeListener highlightChangeListener) {
        if (!this.highlightChangeListeners.contains(highlightChangeListener)) {
            this.highlightChangeListeners.add(highlightChangeListener);
        }
    }

    public void removeHighlightChangeListener(HighlightChangeListener highlightChangeListener) {
        this.highlightChangeListeners.remove(highlightChangeListener);
    }

    public void fireHighlightChangeListener(boolean bl) {
        for (int i = 0; i < this.highlightChangeListeners.size(); ++i) {
            HighlightChangeListener highlightChangeListener = this.highlightChangeListeners.get(i);
            highlightChangeListener.highlightUpdated(bl);
        }
    }

    public int countHighlights() {
        return this.getRowCount();
    }

    public boolean isHighlightEnable() {
        return jEdit.getBooleanProperty((String)ENABLED_PROP);
    }

    public void setHighlightEnable(boolean bl) {
        jEdit.setBooleanProperty((String)ENABLED_PROP, (boolean)bl);
        this.fireHighlightChangeListener(bl);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        JEditTextArea jEditTextArea = (JEditTextArea)caretEvent.getSource();
        int n = jEditTextArea.getCaretLine();
        boolean bl = false;
        if (this.highlightWordAtCaret) {
            if (jEditTextArea.getLineLength(n) == 0 || jEditTextArea.getSelectionCount() != 0) {
                if (currentWordHighlight.isEnabled()) {
                    bl = true;
                    currentWordHighlight.setEnabled(false);
                }
            } else {
                int n2 = jEditTextArea.getLineStartOffset(n);
                int n3 = jEditTextArea.getCaretPosition() - n2;
                JEditBuffer jEditBuffer = jEditTextArea.getBuffer();
                CharSequence charSequence = jEditBuffer.getLineSegment(n);
                String string = jEditBuffer.getStringProperty("noWordSep");
                if (n3 != 0) {
                    --n3;
                }
                int n4 = TextUtilities.findWordStart((CharSequence)charSequence, (int)n3, (String)string);
                char c = charSequence.charAt(n4);
                if (!this.highlightWordAtCaretWhitespace && Character.isWhitespace(c) || this.highlightWordAtCaretOnlyWords && !Character.isLetterOrDigit(c) && string.indexOf(c) == -1) {
                    if (currentWordHighlight.isEnabled()) {
                        bl = true;
                        currentWordHighlight.setEnabled(false);
                    }
                } else {
                    int n5 = TextUtilities.findWordEnd((CharSequence)charSequence, (int)(n3 + 1), (String)string);
                    if (n5 - n4 < 2) {
                        if (currentWordHighlight.isEnabled()) {
                            bl = true;
                            currentWordHighlight.setEnabled(false);
                        }
                    } else {
                        if (!currentWordHighlight.isEnabled()) {
                            bl = true;
                            currentWordHighlight.setEnabled(true);
                        }
                        String string2 = charSequence.subSequence(n4, n5).toString();
                        if (this.highlightWordAtCaretEntireWord) {
                            string2 = "\\b" + string2 + "\\b";
                            if (!string2.equals(currentWordHighlight.getStringToHighlight())) {
                                bl = true;
                                currentWordHighlight.init(string2, true, currentWordHighlight.isIgnoreCase(), currentWordHighlight.getColor());
                            }
                        } else if (!string2.equals(currentWordHighlight.getStringToHighlight())) {
                            bl = true;
                            currentWordHighlight.setStringToHighlight(string2);
                        }
                    }
                }
            }
        }
        if (this.highlightSelection) {
            Selection selection = jEditTextArea.getSelectionAtOffset(caretEvent.getDot());
            if (jEditTextArea.getLineLength(n) == 0 || selection == null || selection.getStartLine() != selection.getEndLine() || selection.getEnd() - selection.getStart() == 0) {
                if (selectionHighlight.isEnabled()) {
                    bl = true;
                    selectionHighlight.setEnabled(false);
                }
            } else {
                String string = jEditTextArea.getSelectedText(selection);
                if (!selectionHighlight.isEnabled() || !string.equals(selectionHighlight.getStringToHighlight())) {
                    bl = true;
                    selectionHighlight.setEnabled(true);
                    selectionHighlight.setStringToHighlight(string);
                }
            }
        }
        if (bl) {
            this.fireHighlightChangeListener(this.isHighlightEnable());
        }
    }

    public boolean isHighlightWordAtCaret() {
        return this.highlightWordAtCaret;
    }

    public boolean isHighlightSelection() {
        return this.highlightSelection;
    }

    public void propertiesChanged() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (jEdit.getBooleanProperty((String)"gatchan.highlight.cycleColor")) {
            Highlight.setDefaultColor(null);
        } else {
            Highlight.setDefaultColor(jEdit.getColorProperty((String)"gatchan.highlight.defaultColor"));
        }
        this.appendHighlight = jEdit.getBooleanProperty((String)"gatchan.highlight.appendHighlight");
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight");
        if (this.highlightWordAtCaret != bl7) {
            bl5 = true;
            this.highlightWordAtCaret = bl7;
            if (!bl7) {
                currentWordHighlight.setEnabled(false);
            }
        }
        if (this.highlightSelection != (bl4 = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight"))) {
            bl6 = true;
            this.highlightSelection = bl4;
            if (!bl4) {
                selectionHighlight.setEnabled(false);
            }
        }
        if (this.highlightWordAtCaretEntireWord != (bl3 = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.entireWord"))) {
            bl5 = true;
            this.highlightWordAtCaretEntireWord = bl3;
            if (bl3) {
                String string = currentWordHighlight.getStringToHighlight();
                currentWordHighlight.setStringToHighlight("\\b" + string + "\\b");
            }
        }
        if (this.highlightWordAtCaretWhitespace != (bl2 = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.whitespace"))) {
            bl5 = true;
            this.highlightWordAtCaretWhitespace = bl2;
        }
        if (this.highlightWordAtCaretOnlyWords != (bl = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.onlyWords"))) {
            bl5 = true;
            this.highlightWordAtCaretOnlyWords = bl;
        }
        boolean bl8 = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.ignoreCase");
        if (currentWordHighlight.isIgnoreCase() != bl8) {
            bl5 = true;
        }
        boolean bl9 = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight.ignoreCase");
        if (selectionHighlight.isIgnoreCase() != bl8) {
            bl6 = true;
        }
        Color color = jEdit.getColorProperty((String)"gatchan.highlight.caretHighlight.color");
        if (!currentWordHighlight.getColor().equals(color)) {
            bl5 = true;
        }
        Color color2 = jEdit.getColorProperty((String)"gatchan.highlight.selectionHighlight.color");
        if (!selectionHighlight.getColor().equals(color2)) {
            bl6 = true;
        }
        Highlighter.square = jEdit.getBooleanProperty((String)"gatchan.highlight.square");
        Highlighter.squareColor = jEdit.getColorProperty((String)"gatchan.highlight.square.color");
        if (bl5) {
            currentWordHighlight.init(currentWordHighlight.getStringToHighlight(), bl3, bl8, color);
        }
        if (bl6) {
            selectionHighlight.init(selectionHighlight.getStringToHighlight(), false, bl9, color2);
        }
        if (bl5 || bl6) {
            this.fireHighlightChangeListener(this.isHighlightEnable());
        }
    }

    public void getReadLock() {
        this.lock.readLock().lock();
    }

    public void releaseLock() {
        this.lock.readLock().unlock();
    }

    public void load(File file) {
        this.removeAll();
        if (file != null && file.exists()) {
            this.loadFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadFile(File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            boolean bl = false;
            if (FILE_VERSION.equals(string)) {
                bl = true;
                string = bufferedReader.readLine();
            }
            while (string != null) {
                try {
                    this.addElement(Highlight.unserialize(string, bl), false);
                }
                catch (InvalidHighlightException invalidHighlightException) {
                    Log.log((int)7, (Object)this, (Object)("Unable to read this highlight, please report it : " + string));
                }
                string = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.log((int)9, (Object)this, (Object)fileNotFoundException);
            IOUtilities.closeQuietly((Reader)bufferedReader);
        }
        catch (IOException iOException) {
            Log.log((int)9, (Object)this, (Object)iOException);
            {
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(bufferedReader);
                    throw throwable;
                }
            }
            IOUtilities.closeQuietly((Reader)bufferedReader);
        }
        IOUtilities.closeQuietly((Reader)bufferedReader);
    }

    private class RemoveExpired
    implements ActionListener {
        private RemoveExpired() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Highlight highlight;
            int n;
            ArrayList<Highlight> arrayList = null;
            try {
                HighlightManagerTableModel.this.lock.readLock().lock();
                for (n = 0; n < HighlightManagerTableModel.this.datas.size(); ++n) {
                    highlight = (Highlight)HighlightManagerTableModel.this.datas.get(n);
                    if (!highlight.isExpired()) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<Highlight>();
                    }
                    arrayList.add(highlight);
                }
            }
            finally {
                HighlightManagerTableModel.this.lock.readLock().unlock();
            }
            if (arrayList != null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    highlight = (Highlight)arrayList.get(n);
                    HighlightManagerTableModel.this.removeRow(highlight);
                }
            }
        }
    }
}

