/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManagerTableModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.IntegerArray;

public class HighlightOverview
extends JPanel
implements HighlightChangeListener {
    private final IntegerArray items;
    private final JEditTextArea textArea;
    private static final int ITEM_HEIGHT = 4;
    private static final int OVERVIEW_WIDTH = 12;
    private static final int ITEM_BORDER = 2;
    private static final int ITEM_WIDTH = 8;
    private static final int Y_OFFSET = 16;
    private static final Dimension preferredSize = new Dimension(12, 0);
    private Color color;

    public HighlightOverview(final JEditTextArea jEditTextArea) {
        Font font = this.getFont();
        Font font2 = new Font(font.getName(), 1, 8);
        this.setFont(font2);
        this.textArea = jEditTextArea;
        this.items = new IntegerArray(32);
        this.setRequestFocusEnabled(false);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = jEditTextArea.getLineCount();
                int n2 = HighlightOverview.this.yToLine(mouseEvent.getY(), n);
                jEditTextArea.setFirstLine(Math.max(n2 - jEditTextArea.getVisibleLines() / 2, 0));
            }
        });
    }

    public void highlightUpdated(boolean bl) {
        View view;
        int n;
        this.items.clear();
        if (!bl || !HighlightManagerTableModel.currentWordHighlight.isEnabled() || this.textArea.getSelectionCount() != 0) {
            this.repaint();
            return;
        }
        int n2 = 0;
        JEditBuffer jEditBuffer = this.textArea.getBuffer();
        boolean bl2 = jEditBuffer.getLineEndOffset(jEditBuffer.getLineOfOffset(n = jEditBuffer.getLength())) - 1 == n;
        SearchMatcher searchMatcher = HighlightManagerTableModel.currentWordHighlight.getSearchMatcher();
        int n3 = -1;
        int n4 = 0;
        while (true) {
            int n5;
            boolean bl3 = jEditBuffer.getLineStartOffset(jEditBuffer.getLineOfOffset(n2)) == n2;
            SearchMatcher.Match match = searchMatcher.nextMatch(jEditBuffer.getSegment(n2, n - n2), bl3, bl2, n4 == 0, false);
            if (match == null) break;
            int n6 = jEditBuffer.getLineOfOffset(n2 + match.start);
            if (n3 != n6) {
                this.items.add(n6);
                n3 = n6;
            }
            if ((n5 = n6 + 1) >= jEditBuffer.getLineCount()) break;
            n2 = jEditBuffer.getLineStartOffset(n5);
            ++n4;
        }
        if ((view = this.textArea.getView()).isActive() && view.getTextArea() == this.textArea) {
            view.getStatus().setMessage(n4 + " lines contains the current word");
        }
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.items.getSize() == 0) {
            return;
        }
        int n = this.textArea.getLineCount();
        if (this.color != null) {
            graphics.setColor(this.color);
        } else {
            graphics.setColor(HighlightManagerTableModel.currentWordHighlight.getColor());
        }
        for (int i = 0; i < this.items.getSize(); ++i) {
            int n2 = this.lineToY(this.items.get(i), n);
            graphics.fillRect(2, n2, 8, 4);
        }
    }

    private int lineToY(int n, int n2) {
        return 16 + (this.getHeight() - 32) * n / n2 - 2;
    }

    private int yToLine(int n, int n2) {
        return (n + 2 - 16) * n2 / (this.getHeight() - 32);
    }

    public Dimension getPreferredSize() {
        return preferredSize;
    }

    public void setOverviewColor(Color color) {
        this.color = color;
    }
}

