/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightDialog;
import gatchan.highlight.HighlightHypersearchResults;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.HighlightManagerTableModel;
import gatchan.highlight.HighlightOverview;
import gatchan.highlight.HighlightSelectFile;
import gatchan.highlight.Highlighter;
import gatchan.highlight.color.FlexColorPainter;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.jedit.visitors.JEditVisitor;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class HighlightPlugin
extends EditPlugin {
    private static HighlightManager highlightManager;
    public static final String LAYER_PROPERTY = "plugin.highlight";
    public static final String NAME = "highlight";
    public static final String PROPERTY_PREFIX = "plugin.Highlight.";
    public static final String MENU = "highlight.menu";
    public static final String OPTION_PREFIX = "options.highlight.";
    private int layer;
    private float alpha;
    private boolean highlightOverview;
    private boolean highlightOverviewSameColor;
    private Color highlightOverviewColor;

    public void start() {
        this.layer = jEdit.getIntegerProperty((String)"gatchan.highlight.layer", (int)Integer.MAX_VALUE);
        this.highlightOverview = jEdit.getBooleanProperty((String)"gatchan.highlight.overview");
        File file = this.dataMigration();
        highlightManager = HighlightManagerTableModel.createInstance(file);
        highlightManager.propertiesChanged();
        jEdit.visit((JEditVisitor)new TextAreaInitializer());
        jEdit.visit((JEditVisitor)new ViewInitializer());
        EditBus.addToBus((Object)((Object)this));
    }

    public void stop() {
        EditBus.removeFromBus((Object)((Object)this));
        jEdit.resetProperty((String)"plugin.gatchan.highlight.HighlightPlugin.activate");
        Buffer[] bufferArray = jEdit.getBuffers();
        for (int i = 0; i < bufferArray.length; ++i) {
            bufferArray[i].unsetProperty("highlights");
        }
        jEdit.visit((JEditVisitor)new TextAreaUninitializer());
        jEdit.visit((JEditVisitor)new ViewUninitializer());
        highlightManager.dispose();
        highlightManager = null;
    }

    private static void uninitTextArea(JEditTextArea jEditTextArea) {
        FlexColorPainter flexColorPainter;
        TextAreaPainter textAreaPainter = jEditTextArea.getPainter();
        Highlighter highlighter = (Highlighter)jEditTextArea.getClientProperty(Highlighter.class);
        if (highlighter != null) {
            textAreaPainter.removeExtension((TextAreaExtension)highlighter);
            jEditTextArea.putClientProperty(Highlighter.class, null);
            highlightManager.removeHighlightChangeListener(highlighter);
        }
        if ((flexColorPainter = (FlexColorPainter)((Object)jEditTextArea.getClientProperty(FlexColorPainter.class))) != null) {
            textAreaPainter.removeExtension((TextAreaExtension)flexColorPainter);
            jEditTextArea.putClientProperty(FlexColorPainter.class, null);
        }
        HighlightPlugin.removeHighlightOverview(jEditTextArea);
        jEditTextArea.removeCaretListener((CaretListener)highlightManager);
    }

    private void initTextArea(JEditTextArea jEditTextArea) {
        Highlighter highlighter = new Highlighter(jEditTextArea);
        highlightManager.addHighlightChangeListener(highlighter);
        TextAreaPainter textAreaPainter = jEditTextArea.getPainter();
        textAreaPainter.addExtension(this.layer, (TextAreaExtension)highlighter);
        jEditTextArea.putClientProperty(Highlighter.class, (Object)highlighter);
        jEditTextArea.addCaretListener((CaretListener)highlightManager);
        FlexColorPainter flexColorPainter = new FlexColorPainter((TextArea)jEditTextArea);
        jEditTextArea.putClientProperty(FlexColorPainter.class, (Object)flexColorPainter);
        textAreaPainter.addExtension(this.layer - 1, (TextAreaExtension)flexColorPainter);
        if (this.highlightOverview) {
            this.addHighlightOverview(jEditTextArea);
        }
        jEditTextArea.revalidate();
    }

    private void addHighlightOverview(JEditTextArea jEditTextArea) {
        HighlightOverview highlightOverview = (HighlightOverview)jEditTextArea.getClientProperty(HighlightOverview.class);
        if (highlightOverview == null) {
            highlightOverview = new HighlightOverview(jEditTextArea);
            highlightManager.addHighlightChangeListener(highlightOverview);
            jEditTextArea.addLeftOfScrollBar((Component)highlightOverview);
            jEditTextArea.putClientProperty(HighlightOverview.class, (Object)highlightOverview);
        }
        if (!jEdit.getBooleanProperty((String)"gatchan.highlight.overview.samecolor")) {
            highlightOverview.setOverviewColor(jEdit.getColorProperty((String)"gatchan.highlight.overview.color"));
        } else {
            highlightOverview.setOverviewColor(null);
        }
    }

    private static void removeHighlightOverview(JEditTextArea jEditTextArea) {
        HighlightOverview highlightOverview = (HighlightOverview)jEditTextArea.getClientProperty(HighlightOverview.class);
        if (highlightOverview != null) {
            jEditTextArea.removeLeftOfScrollBar((Component)highlightOverview);
            jEditTextArea.putClientProperty(HighlightOverview.class, null);
            highlightManager.removeHighlightChangeListener(highlightOverview);
            jEditTextArea.revalidate();
        }
    }

    private HighlightHypersearchResults initView(View view) {
        HighlightHypersearchResults highlightHypersearchResults = new HighlightHypersearchResults(view);
        highlightHypersearchResults.start();
        view.getDockableWindowManager().putClientProperty(HighlightHypersearchResults.class, (Object)highlightHypersearchResults);
        return highlightHypersearchResults;
    }

    private static void uninitView(View view) {
        HighlightHypersearchResults highlightHypersearchResults = (HighlightHypersearchResults)view.getDockableWindowManager().getClientProperty(HighlightHypersearchResults.class);
        if (highlightHypersearchResults == null) {
            return;
        }
        highlightHypersearchResults.stop();
        view.getDockableWindowManager().putClientProperty(HighlightHypersearchResults.class, null);
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        boolean bl = jEdit.getBooleanProperty((String)"gatchan.highlight.overview");
        boolean bl2 = jEdit.getBooleanProperty((String)"gatchan.highlight.overview.samecolor");
        Color color = jEdit.getColorProperty((String)"gatchan.highlight.overview.color");
        int n = jEdit.getIntegerProperty((String)"gatchan.highlight.layer", (int)Integer.MAX_VALUE);
        float f = (float)jEdit.getIntegerProperty((String)"gatchan.highlight.alpha", (int)50) / 100.0f;
        if (this.layer != n || this.alpha != f || bl != this.highlightOverview || bl2 != this.highlightOverviewSameColor || this.highlightOverviewColor != null && !this.highlightOverviewColor.equals(color)) {
            this.highlightOverview = bl;
            this.highlightOverviewSameColor = bl2;
            this.highlightOverviewColor = color;
            this.layer = n;
            this.alpha = f;
            jEdit.visit((JEditVisitor)new JEditVisitorAdapter(){

                public void visit(JEditTextArea jEditTextArea) {
                    TextAreaPainter textAreaPainter = jEditTextArea.getPainter();
                    Highlighter highlighter = (Highlighter)jEditTextArea.getClientProperty(Highlighter.class);
                    highlighter.setAlphaComposite(HighlightPlugin.this.alpha);
                    textAreaPainter.removeExtension((TextAreaExtension)highlighter);
                    textAreaPainter.addExtension(HighlightPlugin.this.layer, (TextAreaExtension)highlighter);
                    if (HighlightPlugin.this.highlightOverview) {
                        HighlightPlugin.this.addHighlightOverview(jEditTextArea);
                    } else {
                        HighlightPlugin.removeHighlightOverview(jEditTextArea);
                    }
                }
            });
        }
        highlightManager.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate viewUpdate) {
        View view = viewUpdate.getView();
        Object object = viewUpdate.getWhat();
        if (object == ViewUpdate.CREATED) {
            this.initView(view);
        } else if (object == ViewUpdate.CLOSED) {
            HighlightPlugin.uninitView(view);
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        JEditTextArea jEditTextArea = editPaneUpdate.getEditPane().getTextArea();
        Object object = editPaneUpdate.getWhat();
        if (object == EditPaneUpdate.CREATED) {
            this.initTextArea(jEditTextArea);
        } else if (object == EditPaneUpdate.DESTROYED) {
            HighlightPlugin.uninitTextArea(jEditTextArea);
        }
    }

    @EditBus.EBHandler
    public void handleBufferPaneUpdate(BufferUpdate bufferUpdate) {
        if (bufferUpdate.getWhat() == BufferUpdate.CLOSED) {
            highlightManager.bufferClosed(bufferUpdate.getBuffer());
        }
    }

    @EditBus.EBHandler
    public void handleDockableWindowUpdate(DockableWindowUpdate dockableWindowUpdate) {
        if (dockableWindowUpdate.getWhat() == DockableWindowUpdate.ACTIVATED && "hypersearch-results".equals(dockableWindowUpdate.getDockable())) {
            View view = ((DockableWindowManager)dockableWindowUpdate.getSource()).getView();
            HighlightHypersearchResults highlightHypersearchResults = (HighlightHypersearchResults)view.getDockableWindowManager().getClientProperty(HighlightHypersearchResults.class);
            if (highlightHypersearchResults == null) {
                this.initView(view);
            } else {
                highlightHypersearchResults.start();
            }
        }
    }

    public static void highlightThis(JEditTextArea jEditTextArea) {
        HighlightPlugin.highlightThis(jEditTextArea, 0);
    }

    public static void highlightThis(JEditTextArea jEditTextArea, int n) {
        String string = HighlightPlugin.getCurrentWord((TextArea)jEditTextArea);
        if (string == null) {
            return;
        }
        Highlight highlight = new Highlight(string);
        highlight.setScope(n);
        if (n == 2) {
            highlight.setBuffer(jEditTextArea.getBuffer());
        }
        highlightManager.addElement(highlight);
    }

    private static String getCurrentWord(TextArea textArea) {
        String string = textArea.getSelectedText();
        if (string == null) {
            textArea.selectWord();
            string = textArea.getSelectedText();
        }
        return string;
    }

    public static void highlightEntireWord(JEditTextArea jEditTextArea) {
        HighlightPlugin.highlightEntireWord(jEditTextArea, 0);
    }

    public static void highlightEntireWord(JEditTextArea jEditTextArea, int n) {
        String string = HighlightPlugin.getCurrentWord((TextArea)jEditTextArea);
        if (string == null) {
            return;
        }
        Highlight highlight = new Highlight("\\b" + string + "\\b", true, false);
        highlight.setScope(n);
        if (n == 2) {
            highlight.setBuffer(jEditTextArea.getBuffer());
        }
        highlightManager.addElement(highlight);
    }

    public static void highlightCurrentSearch() {
        HighlightPlugin.highlightCurrentSearch(0);
    }

    public static void highlightCurrentSearch(int n) {
        Highlight highlight = new Highlight();
        highlight.setScope(n);
        if (n == 2) {
            highlight.setBuffer((JEditBuffer)jEdit.getActiveView().getBuffer());
        }
        highlight.init(SearchAndReplace.getSearchString(), SearchAndReplace.getRegexp(), SearchAndReplace.getIgnoreCase(), Highlight.getNextColor());
        HighlightPlugin.addHighlight(highlight);
    }

    public static void highlightDialog(View view, TextArea textArea) {
        String string = HighlightPlugin.getCurrentWord(textArea);
        HighlightDialog highlightDialog = new HighlightDialog(view);
        if (string != null && string.length() != 0) {
            highlightDialog.setString(string);
        }
        highlightDialog.setVisible(true);
    }

    public static void addHighlight(Highlight highlight) {
        highlightManager.addElement(highlight);
    }

    public static void removeAllHighlights() {
        highlightManager.removeAll();
    }

    public static void enableHighlights() {
        highlightManager.setHighlightEnable(true);
    }

    public static void disableHighlights() {
        highlightManager.setHighlightEnable(false);
    }

    public static void toggleHighlights() {
        highlightManager.setHighlightEnable(!highlightManager.isHighlightEnable());
    }

    public static void highlightHyperSearchResult(View view) {
        HighlightHypersearchResults highlightHypersearchResults = (HighlightHypersearchResults)view.getDockableWindowManager().getClientProperty(HighlightHypersearchResults.class);
        if (highlightHypersearchResults == null) {
            return;
        }
        highlightHypersearchResults.start();
    }

    public static boolean isHighlightEnable() {
        return highlightManager.isHighlightEnable();
    }

    public File dataMigration() {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return null;
        }
        File file = new File(string, "plugins");
        String string2 = new File(file, ((Object)((Object)this)).getClass().getName()).getPath();
        if (string2 == null) {
            return null;
        }
        String string3 = jEdit.getSettingsDirectory() + File.separator + "HighlightPlugin" + File.separator;
        File file2 = new File(string3);
        File file3 = new File(file2, "highlights.ser");
        File file4 = new File(string2);
        if (!file4.exists()) {
            Log.log((int)1, (Object)((Object)this), (Object)("Home doesn't exist, trying to create it " + string2));
            if (!file4.mkdirs()) {
                Log.log((int)9, (Object)((Object)this), (Object)"Unable to create home directory, running Highlight plugin with no Home");
                return null;
            }
        }
        if (!file4.isDirectory() || !file4.canWrite()) {
            Log.log((int)9, (Object)((Object)this), (Object)"Unable to write in home folder");
            return null;
        }
        File file5 = new File(file4, "highlights.ser");
        if (file3.isFile()) {
            Log.log((int)1, (Object)((Object)this), (Object)"Moving data to new home");
            IOUtilities.moveFile((File)file3, (File)file5);
            file3.delete();
            file2.delete();
            return file5;
        }
        return file5;
    }

    public static void load() {
        File file = HighlightSelectFile.showDialog();
        if (file == null) {
            return;
        }
        if (file.exists() && file.canRead()) {
            ((HighlightManagerTableModel)highlightManager).load(file);
            jEdit.getActiveView().getStatus().setMessage("Load : " + file);
        }
    }

    public static void save() {
        File file = HighlightSelectFile.showSaveDialog();
        if (file == null) {
            return;
        }
        if (file.exists() && !file.canWrite()) {
            return;
        }
        ((HighlightManagerTableModel)highlightManager).save(file);
        jEdit.getActiveView().getStatus().setMessage("Save : " + file);
    }

    private class ViewUninitializer
    extends JEditVisitorAdapter {
        private ViewUninitializer() {
        }

        public void visit(View view) {
            HighlightPlugin.uninitView(view);
        }
    }

    private class ViewInitializer
    extends JEditVisitorAdapter {
        private ViewInitializer() {
        }

        public void visit(View view) {
            HighlightPlugin.this.initView(view);
        }
    }

    private class TextAreaUninitializer
    extends JEditVisitorAdapter {
        private TextAreaUninitializer() {
        }

        public void visit(JEditTextArea jEditTextArea) {
            HighlightPlugin.uninitTextArea(jEditTextArea);
        }
    }

    private class TextAreaInitializer
    extends JEditVisitorAdapter {
        private TextAreaInitializer() {
        }

        public void visit(JEditTextArea jEditTextArea) {
            HighlightPlugin.this.initTextArea(jEditTextArea);
        }
    }
}

