/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.HighlightPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HighlightSelectFile {
    private JDialog selectDialog = null;
    private JList list = null;
    private DefaultListModel listModel = null;
    private JTextField tf = null;
    private File selectedFile = null;
    private boolean isSave = false;

    public HighlightSelectFile(boolean bl) {
        this.isSave = bl;
        this.selectDialog = this.createDialog();
    }

    public static File showDialog() {
        return new HighlightSelectFile(false).showSelectDialog();
    }

    public static File showSaveDialog() {
        return new HighlightSelectFile(true).showSelectDialog();
    }

    public File showSelectDialog() {
        File file = null;
        this.reloadList();
        this.tf.setText("");
        this.tf.requestFocus();
        if (this.listModel.getSize() > 0) {
            this.list.setSelectedIndex(0);
            this.list.ensureIndexIsVisible(0);
        }
        this.selectedFile = null;
        this.selectDialog.pack();
        this.selectDialog.setLocationRelativeTo((Component)jEdit.getActiveView());
        this.selectDialog.setVisible(true);
        file = this.selectedFile;
        return file;
    }

    private void reloadList() {
        this.listModel.clear();
        ArrayList<ListElement> arrayList = this.getHighlightFiles();
        for (ListElement listElement : arrayList) {
            this.listModel.addElement(listElement);
        }
    }

    private JDialog createDialog() {
        String string = this.isSave ? "Save" : "Load";
        JDialog jDialog = new JDialog((Frame)jEdit.getActiveView(), string, true);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        this.tf = new JTextField();
        container.add((Component)this.tf, "North");
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        container.add((Component)new JScrollPane(this.list), "Center");
        this.list.setSelectionMode(0);
        JButton jButton = new JButton("DEL");
        container.add((Component)jButton, "South");
        AbstractAction abstractAction = new AbstractAction("nextHighlight"){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = HighlightSelectFile.this.listModel.getSize();
                if (n < 1) {
                    return;
                }
                int n2 = HighlightSelectFile.this.list.getSelectedIndex();
                n2 = (n2 + 1) % n;
                HighlightSelectFile.this.list.setSelectedIndex(n2);
                HighlightSelectFile.this.list.ensureIndexIsVisible(n2);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction("prevHighlight"){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = HighlightSelectFile.this.listModel.getSize();
                if (n < 1) {
                    return;
                }
                int n2 = HighlightSelectFile.this.list.getSelectedIndex();
                n2 += n;
                n2 = (n2 - 1) % n;
                HighlightSelectFile.this.list.setSelectedIndex(n2);
                HighlightSelectFile.this.list.ensureIndexIsVisible(n2);
            }
        };
        final AbstractAction abstractAction3 = new AbstractAction("selectHighlight"){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = HighlightSelectFile.this.tf.getText().trim();
                File file = null;
                if (HighlightSelectFile.this.list.getSelectedIndex() >= 0) {
                    file = ((ListElement)HighlightSelectFile.this.list.getSelectedValue()).file;
                } else if (!"".equals(string)) {
                    file = new File(HighlightSelectFile.this.getHome(), string);
                }
                if (HighlightSelectFile.this.isSave && file.exists()) {
                    Object[] objectArray = new String[]{file.getName()};
                    int n = GUIUtilities.confirm((Component)jEdit.getActiveView(), (String)"fileexists", (Object[])objectArray, (int)0, (int)2);
                    if (n != 0) {
                        return;
                    }
                }
                HighlightSelectFile.this.selectedFile = file;
                HighlightSelectFile.this.selectDialog.setVisible(false);
                HighlightSelectFile.this.selectDialog.dispose();
            }
        };
        AbstractAction abstractAction4 = new AbstractAction("hide"){

            public void actionPerformed(ActionEvent actionEvent) {
                HighlightSelectFile.this.selectDialog.setVisible(false);
                HighlightSelectFile.this.selectDialog.dispose();
            }
        };
        AbstractAction abstractAction5 = new AbstractAction("delHighlight"){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = HighlightSelectFile.this.tf.getText().trim();
                File file = null;
                if (HighlightSelectFile.this.list.getSelectedIndex() >= 0) {
                    file = ((ListElement)HighlightSelectFile.this.list.getSelectedValue()).file;
                } else if (!"".equals(string)) {
                    file = new File(HighlightSelectFile.this.getHome(), string);
                }
                if (file.exists() && file.canWrite()) {
                    Object[] objectArray = new String[]{file.getName(), "files"};
                    int n = GUIUtilities.confirm((Component)jEdit.getActiveView(), (String)"vfs.browser.delete-confirm", (Object[])objectArray, (int)0, (int)2);
                    if (n != 0) {
                        return;
                    }
                    int n2 = HighlightSelectFile.this.list.getSelectedIndex();
                    file.delete();
                    HighlightSelectFile.this.listModel.clear();
                    ArrayList arrayList = HighlightSelectFile.this.getHighlightFiles();
                    for (ListElement listElement : arrayList) {
                        HighlightSelectFile.this.listModel.addElement(listElement);
                    }
                    if (n2 >= HighlightSelectFile.this.listModel.getSize()) {
                        n2 = HighlightSelectFile.this.listModel.getSize() - 1;
                    }
                    HighlightSelectFile.this.list.setSelectedIndex(n2);
                    HighlightSelectFile.this.list.ensureIndexIsVisible(n2);
                    HighlightSelectFile.this.tf.requestFocus();
                }
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke("ESCAPE");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke("UP");
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke("DOWN");
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke("alt I");
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke("alt K");
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke("alt H");
        KeyStroke keyStroke7 = KeyStroke.getKeyStroke("alt 0");
        KeyStroke keyStroke8 = KeyStroke.getKeyStroke("alt DELETE");
        InputMap inputMap = this.tf.getInputMap(2);
        inputMap.put(keyStroke3, abstractAction.getValue("Name"));
        inputMap.put(keyStroke2, abstractAction2.getValue("Name"));
        inputMap.put(keyStroke, abstractAction4.getValue("Name"));
        inputMap.put(keyStroke5, abstractAction.getValue("Name"));
        inputMap.put(keyStroke4, abstractAction2.getValue("Name"));
        inputMap.put(keyStroke6, abstractAction4.getValue("Name"));
        inputMap.put(keyStroke7, abstractAction5.getValue("Name"));
        inputMap.put(keyStroke8, abstractAction5.getValue("Name"));
        ActionMap actionMap = this.tf.getActionMap();
        actionMap.put(abstractAction.getValue("Name"), abstractAction);
        actionMap.put(abstractAction2.getValue("Name"), abstractAction2);
        actionMap.put(abstractAction4.getValue("Name"), abstractAction4);
        actionMap.put(abstractAction5.getValue("Name"), abstractAction5);
        this.tf.addActionListener(abstractAction3);
        this.tf.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if ((keyEvent.getModifiers() & 8) != 0) {
                    return;
                }
                HighlightSelectFile.this.list.getSelectionModel().clearSelection();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    abstractAction3.actionPerformed(null);
                }
            }
        });
        jButton.addActionListener(abstractAction5);
        return jDialog;
    }

    private File getHome() {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return null;
        }
        File file = new File(string, "plugins");
        String string2 = new File(file, HighlightPlugin.class.getName()).getPath();
        if (string2 == null) {
            return null;
        }
        File file2 = new File(string2);
        if (!file2.exists() && !file2.mkdirs()) {
            return null;
        }
        if (!file2.isDirectory() || !file2.canWrite()) {
            return null;
        }
        return file2;
    }

    private ArrayList<ListElement> getHighlightFiles() {
        ArrayList<ListElement> arrayList = new ArrayList<ListElement>();
        File file = this.getHome();
        if (file == null) {
            return null;
        }
        for (File file2 : file.listFiles()) {
            arrayList.add(new ListElement(file2));
        }
        return arrayList;
    }

    private static class ListElement {
        private File file;

        private ListElement(File file) {
            this.file = file;
        }

        public String toString() {
            return this.file.getName();
        }
    }
}

