/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightCellEditor;
import gatchan.highlight.InvalidHighlightException;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.HistoryTextField;

public class HighlightTablePanel
extends JPanel {
    private final HistoryTextField expressionField = new HistoryTextField("gatchan-highlight.expression");
    private final JCheckBox regexp = new JCheckBox("regexp");
    private final JCheckBox ignoreCase = new JCheckBox("ignore case");
    private final ColorWellButton colorBox = new ColorWellButton(Highlight.getNextColor());
    private HighlightCellEditor highlightCellEditor;
    private boolean initialized;
    private Color permanentScopeColor = this.getBackground();
    private static final Color SESSION_SCOPE_COLOR = new Color(204, 204, 255);
    private static final Color BUFFER_SCOPE_COLOR = new Color(255, 252, 192);

    public HighlightTablePanel() {
        super(new GridBagLayout());
        this.ignoreCase.setSelected(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.expressionField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.regexp, gridBagConstraints);
        this.add((Component)this.ignoreCase, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.colorBox, gridBagConstraints);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public void setString(String string) {
        this.expressionField.setText(string);
    }

    public void setDialog(EnhancedDialog enhancedDialog) {
        this.expressionField.addActionListener((ActionListener)new MyActionListener(enhancedDialog));
    }

    public void setHighlight(Highlight highlight) {
        this.expressionField.setText(highlight.getStringToHighlight());
        this.regexp.setSelected(highlight.isRegexp());
        this.ignoreCase.setSelected(highlight.isIgnoreCase());
        this.colorBox.setSelectedColor(highlight.getColor());
        if (this.highlightCellEditor != null) {
            this.expressionField.getDocument().addDocumentListener(this.highlightCellEditor);
            if (!this.initialized) {
                this.regexp.addActionListener(this.highlightCellEditor);
                this.ignoreCase.addActionListener(this.highlightCellEditor);
                ActionListener[] actionListenerArray = this.colorBox.getActionListeners();
                if (actionListenerArray.length == 1) {
                    ActionListener actionListener = actionListenerArray[0];
                    this.colorBox.removeActionListener(actionListener);
                    this.colorBox.addActionListener((ActionListener)new SpecialColorWellButtonActionListener(actionListener, this.highlightCellEditor));
                }
                this.initialized = true;
            }
        }
        switch (highlight.getScope()) {
            case 1: {
                this.changeBackgroundColor(SESSION_SCOPE_COLOR);
                break;
            }
            case 2: {
                this.changeBackgroundColor(BUFFER_SCOPE_COLOR);
                break;
            }
            default: {
                this.changeBackgroundColor(this.permanentScopeColor);
            }
        }
    }

    public void changeBackgroundColor(Color color) {
        this.setBackground(color);
        this.regexp.setBackground(color);
        this.ignoreCase.setBackground(color);
    }

    public void focus() {
        this.expressionField.requestFocus();
    }

    public void save(Highlight highlight) throws InvalidHighlightException {
        String string = this.expressionField.getText();
        if (string.length() == 0) {
            throw new InvalidHighlightException("String cannot be empty");
        }
        highlight.init(string, this.regexp.isSelected(), this.ignoreCase.isSelected(), this.colorBox.getSelectedColor());
        this.expressionField.addCurrentToHistory();
    }

    public void stopEdition() {
        if (this.highlightCellEditor != null) {
            this.expressionField.getDocument().removeDocumentListener(this.highlightCellEditor);
        }
    }

    public void setCellEditor(HighlightCellEditor highlightCellEditor) {
        this.highlightCellEditor = highlightCellEditor;
    }

    private static class MyActionListener
    implements ActionListener {
        private final EnhancedDialog dialog;

        MyActionListener(EnhancedDialog enhancedDialog) {
            this.dialog = enhancedDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.ok();
        }
    }

    private static class SpecialColorWellButtonActionListener
    implements ActionListener {
        private final ActionListener actionListener;
        private final HighlightCellEditor highlightCellEditor;

        SpecialColorWellButtonActionListener(ActionListener actionListener, HighlightCellEditor highlightCellEditor) {
            this.actionListener = actionListener;
            this.highlightCellEditor = highlightCellEditor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.actionListener.actionPerformed(actionEvent);
            this.highlightCellEditor.stopCellEditing();
        }
    }
}

