/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdiff.DiffMessage;
import jdiff.component.ui.BasicMergeToolBarUI;
import jdiff.component.ui.MergeToolBarUI;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;

public class MergeToolBar
extends JComponent
implements EBComponent {
    private static final String uiClassID = "MergeToolBarUI";
    private View view = null;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int COMPACT = 3;
    private int orientation = 1;
    private Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();

    public MergeToolBar(View view) {
        this.view = view;
        this.updateUI();
        EditBus.addToBus((EBComponent)this);
    }

    public void setUI(MergeToolBarUI mergeToolBarUI) {
        super.setUI(mergeToolBarUI);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((MergeToolBarUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicMergeToolBarUI());
        }
        this.fireStateChanged();
    }

    public MergeToolBarUI getUI() {
        return (MergeToolBarUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void removeNotify() {
        EditBus.removeFromBus((EBComponent)this);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            this.changeListeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            this.changeListeners.remove(changeListener);
        }
    }

    public void fireStateChanged() {
        if (this.changeListeners.size() > 0) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public View getView() {
        return this.view;
    }

    public void handleMessage(EBMessage eBMessage) {
        int n;
        if (eBMessage instanceof EditPaneUpdate) {
            EditPaneUpdate editPaneUpdate = (EditPaneUpdate)eBMessage;
            if (!this.view.equals(editPaneUpdate.getEditPane().getView())) {
                return;
            }
            if (editPaneUpdate.getWhat() == EditPaneUpdate.DESTROYED) {
                this.fireStateChanged();
            }
        } else if (eBMessage instanceof DiffMessage) {
            DiffMessage diffMessage = (DiffMessage)eBMessage;
            if (!this.view.equals(diffMessage.getView())) {
                return;
            }
            this.fireStateChanged();
        } else if (eBMessage instanceof ViewUpdate) {
            ViewUpdate viewUpdate = (ViewUpdate)eBMessage;
            if (!this.view.equals(viewUpdate.getView())) {
                return;
            }
            this.fireStateChanged();
        } else if (eBMessage instanceof PropertiesChanged && (n = jEdit.getIntegerProperty((String)"jdiff.toolbar-orientation", (int)this.orientation)) != this.orientation) {
            this.orientation = n;
            this.fireStateChanged();
        }
    }
}

