/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import jdiff.component.DiffLineModel;
import jdiff.component.LineRendererPane;
import jdiff.component.ui.DiffLineOverviewUI;
import org.gjt.sp.jedit.jEdit;

public class BasicLineRendererPaneUI
extends DiffLineOverviewUI
implements ChangeListener {
    private LineRendererPane lineRendererPane = null;
    private JScrollPane scrollPane = null;
    private DiffLineModel model;
    private LineRenderer lineRenderer = null;
    private Color fgColor = jEdit.getColorProperty((String)"view.fgColor", (Color)Color.BLACK);

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicLineRendererPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.lineRendererPane = (LineRendererPane)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void installDefaults() {
        this.lineRendererPane.setLayout(this.createLayoutManager());
        this.lineRendererPane.setBorder(new EmptyBorder(1, 1, 1, 1));
    }

    public void installComponents() {
        this.lineRenderer = new LineRenderer();
        this.scrollPane = new JScrollPane(this.lineRenderer);
        this.lineRendererPane.add((Component)this.scrollPane, "Center");
    }

    public void installListeners() {
        this.lineRendererPane.addChangeListener(this);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.lineRendererPane = null;
    }

    public void uninstallDefaults() {
    }

    public void uninstallComponents() {
        this.lineRenderer = null;
    }

    public void uninstallListeners() {
        this.lineRendererPane.removeChangeListener(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.lineRenderer.repaint();
        if (this.lineRendererPane.getModel() != null) {
            int n;
            String string = this.lineRendererPane.getModel().getLeftLine();
            String string2 = this.lineRendererPane.getModel().getRightLine();
            String string3 = string.length() > string2.length() ? string : string2;
            String string4 = string.length() <= string2.length() ? string : string2;
            int n2 = string4.length();
            for (n = 0; n < string4.length(); ++n) {
                if (string4.charAt(n) == string3.charAt(n)) continue;
                n2 = n;
                break;
            }
            n = string3.length();
            float f = (float)n2 / (float)n;
            int n3 = (int)((float)this.scrollPane.getViewport().getViewRect().width * f);
            Point point = this.scrollPane.getViewport().getViewPosition();
            point.x = n3;
            this.scrollPane.getViewport().setViewPosition(point);
        }
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    public class LineRenderer
    extends JPanel {
        private int leftMargin = 6;
        private int preferredWidth = 600;
        private int preferredHeight = 100;
        private Dimension minimumSize = new Dimension(600, 100);

        public LineRenderer() {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }

        public Dimension getMinimumSize() {
            return this.minimumSize;
        }

        private boolean isSplit() {
            if (BasicLineRendererPaneUI.this.lineRendererPane.getView() == null) {
                return false;
            }
            return BasicLineRendererPaneUI.this.lineRendererPane.getView().getEditPanes().length == 2;
        }

        public void paintComponent(Graphics graphics) {
            int n;
            Color color;
            if (!"none".equals(jEdit.getProperty((String)"view.antiAlias"))) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            super.paintComponent(graphics);
            Rectangle rectangle = this.getBounds();
            graphics.setColor(BasicLineRendererPaneUI.this.lineRendererPane.getBackground());
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            BasicLineRendererPaneUI.this.model = BasicLineRendererPaneUI.this.lineRendererPane.getModel();
            if (BasicLineRendererPaneUI.this.model == null) {
                return;
            }
            if (!this.isSplit()) {
                return;
            }
            String string = BasicLineRendererPaneUI.this.model.getLeftLine();
            String string2 = BasicLineRendererPaneUI.this.model.getRightLine();
            Font font = BasicLineRendererPaneUI.this.lineRendererPane.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            this.preferredHeight = 8 * fontMetrics.getHeight();
            int n2 = this.leftMargin;
            graphics.setColor(BasicLineRendererPaneUI.this.fgColor);
            graphics.drawString("Left", n2, fontMetrics.getHeight());
            int n3 = fontMetrics.stringWidth(string);
            int n4 = fontMetrics.getHeight() / 2;
            int n5 = fontMetrics.getHeight() + n4;
            graphics.drawLine(n2, n5, n2 + n3, n5);
            graphics.drawLine(n2, n5, n2, n5 + n4);
            graphics.drawLine(n2 + n3, n5, n2 + n3, n5 + n4);
            this.preferredWidth = Math.max(this.minimumSize.width, n2 + n3 + this.leftMargin);
            n2 = this.leftMargin;
            int n6 = 3 * fontMetrics.getHeight();
            int n7 = n6 + fontMetrics.getHeight() + 3;
            List<Character> list = BasicLineRendererPaneUI.this.model.getLeftCharacters();
            List<Color> list2 = BasicLineRendererPaneUI.this.model.getLeftColors();
            for (int i = 0; i < list.size(); ++i) {
                char c = list.get(i).charValue();
                if (c == '\n') {
                    c = 'n';
                }
                if (c == '\r') {
                    c = 'r';
                }
                color = list2.get(i);
                graphics.setColor(color);
                graphics.fillRect(n2, n6 - fontMetrics.getHeight() + fontMetrics.getDescent(), fontMetrics.charWidth(c), fontMetrics.getHeight());
                graphics.setColor(BasicLineRendererPaneUI.this.fgColor);
                graphics.drawString(String.valueOf(c), n2, n6);
                n2 += fontMetrics.charWidth(c);
            }
            n2 = this.leftMargin;
            List<Character> list3 = BasicLineRendererPaneUI.this.model.getRightCharacters();
            List<Color> list4 = BasicLineRendererPaneUI.this.model.getRightColors();
            for (n = 0; n < list3.size(); ++n) {
                char c = list3.get(n).charValue();
                if (c == '\n') {
                    c = 'n';
                }
                if (c == '\r') {
                    c = 'r';
                }
                color = list4.get(n);
                graphics.setColor(color);
                graphics.fillRect(n2, n7 - fontMetrics.getHeight() + fontMetrics.getDescent(), fontMetrics.charWidth(c), fontMetrics.getHeight());
                graphics.setColor(BasicLineRendererPaneUI.this.fgColor);
                graphics.drawString(String.valueOf(c), n2, n7);
                n2 += fontMetrics.charWidth(c);
            }
            n2 = this.leftMargin;
            graphics.setColor(BasicLineRendererPaneUI.this.fgColor);
            graphics.setFont(font);
            graphics.drawString("Right", n2, 6 * fontMetrics.getHeight());
            n = fontMetrics.stringWidth(string2);
            n5 = n7 + fontMetrics.getHeight() / 2;
            graphics.drawLine(n2, n5, n2 + n, n5);
            graphics.drawLine(n2, n5, n2, n5 - n4);
            graphics.drawLine(n2 + n, n5, n2 + n, n5 - n4);
            this.preferredWidth = Math.max(this.preferredWidth, n2 + n + this.leftMargin);
            BasicLineRendererPaneUI.this.scrollPane.revalidate();
        }
    }
}

