/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component.ui;

import ise.java.awt.KappaLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import jdiff.DualDiffManager;
import jdiff.component.MergeToolBar;
import jdiff.component.SquareButton;
import jdiff.component.ui.MergeToolBarUI;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class BasicMergeToolBarUI
extends MergeToolBarUI
implements ChangeListener {
    private MergeToolBar toolbar;
    private View view;
    private JButton next;
    private JButton prev;
    private JButton move_right;
    private JButton move_left;
    private JButton unsplit;
    private JButton swap;
    private JButton diff;
    private JButton refresh;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMergeToolBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.toolbar = (MergeToolBar)jComponent;
        this.view = this.toolbar.getView();
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void installDefaults() {
        this.toolbar.setLayout(this.createLayoutManager());
        this.toolbar.setBorder(new EmptyBorder(1, 1, 1, 1));
    }

    public void installComponents() {
        this.diff = new SquareButton(new ImageIcon(BasicMergeToolBarUI.class.getClassLoader().getResource("jdiff/component/resources/delta.png")));
        this.next = new SquareButton(GUIUtilities.loadIcon((String)"22x22/actions/go-down.png"));
        this.prev = new SquareButton(GUIUtilities.loadIcon((String)"22x22/actions/go-up.png"));
        this.move_right = new SquareButton(GUIUtilities.loadIcon((String)"22x22/actions/go-next.png"));
        this.move_left = new SquareButton(GUIUtilities.loadIcon((String)"22x22/actions/go-previous.png"));
        this.unsplit = new SquareButton(GUIUtilities.loadIcon((String)"22x22/actions/window-unsplit.png"));
        this.swap = new SquareButton(GUIUtilities.loadIcon((String)"22x22/actions/window-split-vertical.png"));
        this.refresh = new SquareButton(GUIUtilities.loadIcon((String)"22x22/actions/view-refresh.png"));
        this.diff.setEnabled(true);
        this.next.setEnabled(false);
        this.prev.setEnabled(false);
        this.move_right.setEnabled(false);
        this.move_left.setEnabled(false);
        this.unsplit.setEnabled(false);
        this.swap.setEnabled(false);
        this.refresh.setEnabled(false);
        this.diff.setToolTipText(jEdit.getProperty((String)"jdiff.diff-btn.label", (String)"Diff"));
        this.next.setToolTipText(jEdit.getProperty((String)"jdiff.next-diff.label", (String)"Go to next diff"));
        this.prev.setToolTipText(jEdit.getProperty((String)"jdiff.prev-diff.label", (String)"Go to previous diff"));
        this.unsplit.setToolTipText(jEdit.getProperty((String)"jdiff.unsplit.label", (String)"Unsplit"));
        this.swap.setToolTipText(jEdit.getProperty((String)"jdiff.swap-textareas", (String)"Swap text areas"));
        this.move_right.setToolTipText(jEdit.getProperty((String)"jdiff.move-right.label", (String)"Move diff to right"));
        this.move_left.setToolTipText(jEdit.getProperty((String)"jdiff.move-left.label", (String)"Move diff to left"));
        this.refresh.setToolTipText(jEdit.getProperty((String)"jdiff.refresh.label", (String)"Refresh diff"));
        this.installButtons();
    }

    private void installButtons() {
        int n = jEdit.getIntegerProperty((String)"jdiff.toolbar-orientation", (int)1);
        this.toolbar.removeAll();
        this.toolbar.setLayout(this.createLayoutManager());
        switch (n) {
            case 2: {
                this.toolbar.add("0, 0", this.diff);
                this.toolbar.add("0, 1", this.unsplit);
                this.toolbar.add("0, 2", this.next);
                this.toolbar.add("0, 3", this.prev);
                this.toolbar.add("0, 4", this.move_right);
                this.toolbar.add("0, 5", this.move_left);
                this.toolbar.add("0, 8", this.swap);
                this.toolbar.add("0, 9", this.refresh);
                break;
            }
            case 3: {
                this.toolbar.add("0, 0", this.diff);
                this.toolbar.add("1, 0", this.unsplit);
                this.toolbar.add("0, 1", this.next);
                this.toolbar.add("1, 1", this.prev);
                this.toolbar.add("0, 2", this.move_right);
                this.toolbar.add("1, 2", this.move_left);
                this.toolbar.add("0, 4", this.swap);
                this.toolbar.add("1, 4", this.refresh);
                break;
            }
            default: {
                this.toolbar.add("0, 0", this.diff);
                this.toolbar.add("1, 0", this.unsplit);
                this.toolbar.add("2, 0", this.next);
                this.toolbar.add("3, 0", this.move_right);
                this.toolbar.add("4, 0", this.move_left);
                this.toolbar.add("7, 0", this.prev);
                this.toolbar.add("8, 0", this.swap);
                this.toolbar.add("9, 0", this.refresh);
            }
        }
        this.toolbar.repaint();
    }

    public void installListeners() {
        this.toolbar.addChangeListener(this);
        this.move_left.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BasicMergeToolBarUI.this.view != null) {
                    if ((actionEvent.getModifiers() & 1) != 0) {
                        DualDiffManager.moveMultipleLeft(BasicMergeToolBarUI.this.view.getEditPane());
                    } else {
                        DualDiffManager.moveLeft(BasicMergeToolBarUI.this.view.getEditPane());
                    }
                }
            }
        });
        this.move_right.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BasicMergeToolBarUI.this.view != null) {
                    if ((actionEvent.getModifiers() & 1) != 0) {
                        DualDiffManager.moveMultipleRight(BasicMergeToolBarUI.this.view.getEditPane());
                    } else {
                        DualDiffManager.moveRight(BasicMergeToolBarUI.this.view.getEditPane());
                    }
                }
            }
        });
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BasicMergeToolBarUI.this.view != null) {
                    DualDiffManager.nextDiff(BasicMergeToolBarUI.this.view.getEditPane());
                }
            }
        });
        this.prev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BasicMergeToolBarUI.this.view != null) {
                    DualDiffManager.prevDiff(BasicMergeToolBarUI.this.view.getEditPane());
                }
            }
        });
        this.unsplit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DualDiffManager.toggleFor(BasicMergeToolBarUI.this.view);
                BasicMergeToolBarUI.this.toolbar.repaint();
            }
        });
        this.swap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BasicMergeToolBarUI.this.view != null) {
                    EditPane editPane = BasicMergeToolBarUI.this.view.getEditPanes()[0];
                    EditPane editPane2 = BasicMergeToolBarUI.this.view.getEditPanes()[1];
                    Buffer buffer = editPane.getBuffer();
                    Buffer buffer2 = editPane2.getBuffer();
                    editPane.setBuffer(buffer2);
                    editPane2.setBuffer(buffer);
                }
            }
        });
        this.diff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DualDiffManager.toggleFor(BasicMergeToolBarUI.this.view);
                BasicMergeToolBarUI.this.toolbar.repaint();
            }
        });
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DualDiffManager.refreshFor(BasicMergeToolBarUI.this.view);
                BasicMergeToolBarUI.this.toolbar.repaint();
            }
        });
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
    }

    public void uninstallDefaults() {
    }

    public void uninstallComponents() {
    }

    public void uninstallListeners() {
        this.toolbar.removeChangeListener(this);
    }

    protected LayoutManager createLayoutManager() {
        return new KappaLayout();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.installButtons();
        this.adjustButtons();
    }

    private void adjustButtons() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = DualDiffManager.isEnabledFor(BasicMergeToolBarUI.this.view);
                BasicMergeToolBarUI.this.diff.setEnabled(!bl);
                BasicMergeToolBarUI.this.next.setEnabled(bl);
                BasicMergeToolBarUI.this.prev.setEnabled(bl);
                BasicMergeToolBarUI.this.move_right.setEnabled(bl);
                BasicMergeToolBarUI.this.move_left.setEnabled(bl);
                BasicMergeToolBarUI.this.unsplit.setEnabled(bl);
                BasicMergeToolBarUI.this.swap.setEnabled(bl);
                BasicMergeToolBarUI.this.refresh.setEnabled(bl);
                BasicMergeToolBarUI.this.toolbar.repaint();
            }
        });
    }
}

