/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import jdiff.DualDiff;
import jdiff.text.FileLine;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.TextArea;

public class DualDiffUtil {
    public static boolean ignoreCaseDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-case", (boolean)false);
    public static boolean trimWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.trim-whitespace", (boolean)false);
    public static boolean ignoreAmountOfWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)false);
    public static boolean ignoreLineSeparatorsDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-line-separators", (boolean)true);
    public static boolean ignoreAllWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)false);

    public static void propertiesChanged() {
        ignoreCaseDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-case", (boolean)false);
        trimWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.trim-whitespace", (boolean)false);
        ignoreAmountOfWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-amount-whitespace", (boolean)false);
        ignoreLineSeparatorsDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-line-separators", (boolean)true);
        ignoreAllWhitespaceDefault = jEdit.getBooleanProperty((String)"jdiff.ignore-all-whitespace", (boolean)false);
    }

    public static String getCurrentLineText(TextArea textArea) {
        if (textArea == null) {
            return "";
        }
        int n = textArea.getCaretPosition();
        int n2 = textArea.getLineOfOffset(n);
        return textArea.getLineText(n2);
    }

    public static void alignCaretLeft(TextArea textArea) {
        int n = textArea.getCaretPosition();
        int n2 = textArea.getLineOfOffset(n);
        int n3 = textArea.getLineStartOffset(n2);
        int n4 = n - n3;
        Point point = textArea.offsetToXY(n2, n4);
        textArea.setHorizontalOffset(-1 * (Math.abs(textArea.getHorizontalOffset()) + point.x));
    }

    public static int firstNoMatch(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            return 0;
        }
        boolean bl = jEdit.getBooleanProperty((String)"jdiff.ignore-case");
        if (bl ? string == string2 || string.equalsIgnoreCase(string2) : string == string2 || string.equals(string2)) {
            return -1;
        }
        if (string.charAt(0) != string2.charAt(0)) {
            return 0;
        }
        int n2 = Math.min(string.length(), string2.length());
        if (bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        for (n = 0; n < n2 && string.charAt(n) == string2.charAt(n); ++n) {
        }
        return n;
    }

    public static void centerOnDiff(TextArea textArea, TextArea textArea2) {
        if (textArea == null || textArea2 == null) {
            return;
        }
        String string = DualDiffUtil.getCurrentLineText(textArea);
        String string2 = DualDiffUtil.getCurrentLineText(textArea2);
        int n = DualDiffUtil.firstNoMatch(string, string2);
        textArea.setCaretPosition(textArea.getCaretPosition() + n, false);
        textArea2.setCaretPosition(textArea2.getCaretPosition() + n, false);
        DualDiffUtil.alignCaretLeft(textArea);
        DualDiffUtil.alignCaretLeft(textArea2);
    }

    public static void center(Component component, Component component2) {
        int n;
        Rectangle rectangle = component.getBounds();
        Dimension dimension = component2.getSize();
        int n2 = rectangle.x + (rectangle.width - dimension.width) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = rectangle.y + (rectangle.height - dimension.height) / 2) < 0) {
            n = 0;
        }
        component2.setLocation(n2, n);
    }

    public static FileLine[] getFileLines(DualDiff dualDiff, Buffer buffer) {
        buffer.readLock();
        FileLine[] fileLineArray = new FileLine[buffer.getLineCount()];
        String string = buffer.getStringProperty("lineSeparator");
        for (int i = buffer.getLineCount() - 1; i >= 0; --i) {
            String string2 = buffer.getLineText(i);
            fileLineArray[i] = DualDiffUtil.getFileLine(dualDiff, string2, string);
        }
        buffer.readUnlock();
        return fileLineArray;
    }

    public static FileLine getFileLine(DualDiff dualDiff, String string, String string2) {
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        String string3 = string;
        if (dualDiff.getIgnoreCase()) {
            string3 = string3.toUpperCase();
        }
        if (dualDiff.getTrimWhitespace() && !dualDiff.getIgnoreAllWhitespace()) {
            string3 = DualDiffUtil.trimWhitespaces(string3);
            if (!dualDiff.getIgnoreLineSeparators()) {
                string3 = string3 + string2;
            }
        }
        if (dualDiff.getIgnoreAmountOfWhitespace() && !dualDiff.getIgnoreAllWhitespace()) {
            string3 = DualDiffUtil.squeezeRepeatedWhitespaces(string3);
            if (!dualDiff.getIgnoreLineSeparators()) {
                string3 = string3 + string2;
            }
        }
        if (dualDiff.getIgnoreLineSeparators() && string3.endsWith(string2)) {
            string3 = string3.substring(0, string3.length() - string2.length());
        }
        if (dualDiff.getIgnoreAllWhitespace()) {
            string3 = DualDiffUtil.removeWhitespaces(string3);
        }
        return new FileLine(string, string3);
    }

    public static String squeezeRepeatedWhitespaces(String string) {
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        string.getChars(0, n, cArray, 0);
        boolean bl = false;
        string = DualDiffUtil.trimWhitespaces(string);
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(cArray[i])) {
                bl = true;
                continue;
            }
            if (bl) {
                cArray2[n2++] = 32;
                bl = false;
            }
            cArray2[n2++] = cArray[i];
        }
        return new String(cArray2, 0, n2);
    }

    public static String removeWhitespaces(String string) {
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            cArray2[n2] = cArray[i];
            ++n2;
        }
        return new String(cArray2, 0, n2);
    }

    public static String trimWhitespaces(String string) {
        return DualDiffUtil.trimLeadingWhitespace(DualDiffUtil.trimTrailingWhitespace(string));
    }

    private static String trimLeadingWhitespace(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return string.substring(n);
    }

    private static String trimTrailingWhitespace(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && Character.isWhitespace(string.charAt(n)); --n) {
        }
        return string.substring(0, n + 1);
    }
}

