/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util.patch;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class PatchUtils {
    public static final int NORMAL = 0;
    public static final int EDIT = 1;
    public static final int CONTEXT = 2;
    public static final int UNIFIED = 3;

    public static int getPatchType(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string2 = bufferedReader.readLine();
        if (string2.startsWith("---")) {
            return 3;
        }
        if (string2.startsWith("***")) {
            return 2;
        }
        while (string2 != null) {
            if (string2.length() == 0) {
                return 1;
            }
            char c = string2.charAt(0);
            if (c == '-' || c == '<' || c == '>' || Character.isDigit(c)) {
                string2 = bufferedReader.readLine();
                continue;
            }
            return 1;
        }
        return 0;
    }

    public static String loadPatchFile(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        StringWriter stringWriter = new StringWriter();
        PatchUtils.copyToWriter(bufferedReader, stringWriter);
        return stringWriter.toString();
    }

    public static void copyToWriter(Reader reader, Writer writer) throws Exception {
        int n;
        char[] cArray = new char[8192];
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
        writer.flush();
        reader.close();
    }

    public static void main(String[] stringArray) {
        try {
            String string = "/home/danson/src/plugins/JDiffPlugin/test/unified_diff.diff";
            String string2 = PatchUtils.loadPatchFile(string);
            int n = PatchUtils.getPatchType(string2);
            System.out.println("Unified diff identification passed? " + (3 == n));
            string = "/home/danson/src/plugins/JDiffPlugin/test/context_diff.diff";
            string2 = PatchUtils.loadPatchFile(string);
            n = PatchUtils.getPatchType(string2);
            System.out.println("Context diff identification passed? " + (2 == n));
            string = "/home/danson/src/plugins/JDiffPlugin/test/normal_diff.diff";
            string2 = PatchUtils.loadPatchFile(string);
            n = PatchUtils.getPatchType(string2);
            System.out.println("Normal diff identification passed? " + (0 == n));
            string = "/home/danson/src/plugins/JDiffPlugin/test/edit_diff.diff";
            string2 = PatchUtils.loadPatchFile(string);
            n = PatchUtils.getPatchType(string2);
            System.out.println("Edit diff identification passed? " + (1 == n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

