/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import java.util.HashSet;
import java.util.Set;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdiff.DualDiff;
import jdiff.component.DiffOverview;
import jdiff.component.ui.BasicDiffLocalOverviewUI;
import jdiff.component.ui.DiffLocalOverviewUI;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class DiffLocalOverview
extends DiffOverview {
    private static final String uiClassID = "DiffLocalOverviewUI";
    private Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();

    public DiffLocalOverview(DualDiff dualDiff) {
        super(dualDiff);
        this.updateUI();
    }

    public void setUI(DiffLocalOverviewUI diffLocalOverviewUI) {
        super.setUI(diffLocalOverviewUI);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((DiffLocalOverviewUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicDiffLocalOverviewUI());
        }
    }

    public DiffLocalOverviewUI getUI() {
        return (DiffLocalOverviewUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() instanceof JEditTextArea) {
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            this.changeListeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            this.changeListeners.remove(changeListener);
        }
    }

    public void fireStateChanged() {
        if (this.changeListeners.size() > 0) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public void moveRight(int n) {
        this.getUI().moveRight(n);
    }

    public void moveLeft(int n) {
        this.getUI().moveLeft(n);
    }
}

