/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import java.util.HashMap;
import jdiff.DualDiff;
import jdiff.util.Diff;
import jdiff.util.DualDiffUtil;
import jdiff.util.JDiffDiff;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.textarea.JEditTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffTextAreaModel {
    private DualDiff dualDiff;
    private Diff.Change edits = null;
    private HashMap<Integer, Diff.Change> leftHunkMap = null;
    private HashMap<Integer, Diff.Change> rightHunkMap = null;
    private int leftLineCount;
    private int rightLineCount;
    private JEditTextArea leftTextArea;
    private JEditTextArea rightTextArea;

    public DiffTextAreaModel(DualDiff dualDiff) {
        this.dualDiff = dualDiff;
        this.prepData();
    }

    public Diff.Change getEdits() {
        return this.edits;
    }

    public int getLeftLineCount() {
        return this.leftLineCount;
    }

    public int getRightLineCount() {
        return this.rightLineCount;
    }

    public JEditTextArea getLeftTextArea() {
        return this.leftTextArea;
    }

    public JEditTextArea getRightTextArea() {
        return this.rightTextArea;
    }

    public HashMap<Integer, Diff.Change> getLeftHunkMap() {
        return this.leftHunkMap;
    }

    public HashMap<Integer, Diff.Change> getRightHunkMap() {
        return this.rightHunkMap;
    }

    private void prepData() {
        EditPane editPane = this.dualDiff.getEditPane0();
        EditPane editPane2 = this.dualDiff.getEditPane1();
        Buffer buffer = editPane.getBuffer();
        Buffer buffer2 = editPane2.getBuffer();
        this.leftTextArea = editPane.getTextArea();
        this.rightTextArea = editPane2.getTextArea();
        if (!buffer.isLoaded() || !buffer2.isLoaded()) {
            this.edits = null;
            this.leftLineCount = buffer.isLoaded() ? buffer.getLineCount() : 1;
            this.rightLineCount = buffer2.isLoaded() ? buffer2.getLineCount() : 1;
        } else {
            Object[] objectArray = DualDiffUtil.getFileLines(this.dualDiff, buffer);
            Object[] objectArray2 = DualDiffUtil.getFileLines(this.dualDiff, buffer2);
            JDiffDiff jDiffDiff = new JDiffDiff(objectArray, objectArray2);
            this.edits = jDiffDiff.diff_2();
            this.leftHunkMap = new HashMap();
            this.rightHunkMap = new HashMap();
            Diff.Change change = this.edits;
            while (change != null) {
                int n;
                for (n = 0; n < Math.max(1, change.lines0); ++n) {
                    this.leftHunkMap.put(change.first0 + n, change);
                }
                for (n = 0; n < Math.max(1, change.lines1); ++n) {
                    this.rightHunkMap.put(change.first1 + n, change);
                }
                change = change.next;
            }
            this.leftLineCount = objectArray.length;
            this.rightLineCount = objectArray2.length;
        }
    }
}

