/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import java.awt.Color;
import java.awt.Font;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdiff.DualDiff;
import jdiff.DualDiffManager;
import jdiff.component.DiffLineModel;
import jdiff.component.ui.BasicLineRendererPaneUI;
import jdiff.component.ui.LineRendererPaneUI;
import jdiff.util.Diff;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class LineRendererPane
extends JComponent
implements EBComponent,
CaretListener {
    private static final String uiClassID = "LineRendererPaneUI";
    private View view = null;
    private DiffLineModel diffLineModel = null;
    private LineProcessorRunner runner = new LineProcessorRunner();
    private Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();

    public LineRendererPane(View view) {
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        this.view = view;
        this.updateUI();
        EditBus.addToBus((EBComponent)this);
    }

    public void setUI(LineRendererPaneUI lineRendererPaneUI) {
        super.setUI(lineRendererPaneUI);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((LineRendererPaneUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicLineRendererPaneUI());
        }
        this.fireStateChanged();
    }

    public LineRendererPaneUI getUI() {
        return (LineRendererPaneUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            this.changeListeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            this.changeListeners.remove(changeListener);
        }
    }

    public void fireStateChanged() {
        if (this.changeListeners.size() > 0) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public View getView() {
        return this.view;
    }

    public void setModel(DiffLineModel diffLineModel) {
        this.diffLineModel = diffLineModel;
        this.fireStateChanged();
    }

    public DiffLineModel getModel() {
        return this.diffLineModel;
    }

    public Color getBackground() {
        return this.view.getEditPane().getTextArea().getPainter().getBackground();
    }

    public Font getFont() {
        return this.view.getEditPane().getTextArea().getPainter().getFont();
    }

    public void clear() {
        this.setModel(null);
    }

    public void reset() {
        this.fireStateChanged();
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof EditPaneUpdate) {
            EditPaneUpdate editPaneUpdate = (EditPaneUpdate)eBMessage;
            if (editPaneUpdate.getWhat() == EditPaneUpdate.DESTROYED) {
                this.fireStateChanged();
            }
        } else if (eBMessage instanceof ViewUpdate) {
            this.fireStateChanged();
        }
        this.maybeAddCaretListeners();
    }

    private void maybeAddCaretListeners() {
        if (this.view == null) {
            return;
        }
        for (EditPane editPane : this.view.getEditPanes()) {
            editPane.getTextArea().removeCaretListener((CaretListener)this);
        }
        if (this.view.getEditPanes().length == 2) {
            this.view.getEditPanes()[0].getTextArea().addCaretListener((CaretListener)this);
            this.view.getEditPanes()[1].getTextArea().addCaretListener((CaretListener)this);
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() instanceof JEditTextArea) {
            JEditTextArea jEditTextArea = (JEditTextArea)caretEvent.getSource();
            this.runner.setSource(jEditTextArea);
            SwingUtilities.invokeLater(this.runner);
        }
    }

    class LineProcessorRunner
    implements Runnable {
        JEditTextArea source = null;

        LineProcessorRunner() {
        }

        public void setSource(JEditTextArea jEditTextArea) {
            this.source = jEditTextArea;
        }

        public void run() {
            int n;
            int n2;
            if (this.source == null) {
                LineRendererPane.this.setModel(null);
                return;
            }
            DualDiff dualDiff = DualDiffManager.getDualDiffFor(LineRendererPane.this.view);
            if (dualDiff == null) {
                LineRendererPane.this.setModel(null);
                return;
            }
            Diff.Change change = dualDiff.getEdits();
            if (change == null) {
                LineRendererPane.this.setModel(null);
                return;
            }
            if (LineRendererPane.this.view.getEditPanes().length != 2) {
                return;
            }
            JEditTextArea jEditTextArea = LineRendererPane.this.view.getEditPanes()[0].getTextArea();
            JEditTextArea jEditTextArea2 = LineRendererPane.this.view.getEditPanes()[1].getTextArea();
            String string = "";
            String string2 = "";
            if (this.source == jEditTextArea) {
                n2 = jEditTextArea.getCaretLine();
                while (change != null) {
                    if (n2 >= change.first0 && n2 < change.first0 + change.lines0) {
                        string = change.lines0 == 0 && change.first0 > 0 ? "" : jEditTextArea.getLineText(n2);
                        n = n2 - change.first0;
                        string2 = n < change.lines1 ? jEditTextArea2.getLineText(change.first1 + n) : "";
                        break;
                    }
                    change = change.next;
                }
            } else {
                n2 = jEditTextArea2.getCaretLine();
                while (change != null) {
                    if (n2 >= change.first1 && n2 < change.first1 + change.lines1) {
                        string2 = change.lines1 == 0 && change.first1 > 0 ? "" : jEditTextArea2.getLineText(n2);
                        n = n2 - change.first1;
                        string = n < change.lines0 ? jEditTextArea.getLineText(change.first0 + n) : "";
                        break;
                    }
                    change = change.next;
                }
            }
            if (!dualDiff.getIgnoreLineSeparators()) {
                String string3 = LineRendererPane.this.view.getEditPanes()[0].getBuffer().getStringProperty("lineSeparator");
                String string4 = LineRendererPane.this.view.getEditPanes()[1].getBuffer().getStringProperty("lineSeparator");
                string = string + string3;
                string2 = string2 + string4;
            }
            if (string.equals(string2)) {
                LineRendererPane.this.setModel(null);
            } else {
                LineRendererPane.this.setModel(new DiffLineModel(string, string2));
            }
        }
    }
}

