/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import jdiff.JDiffPlugin;
import jdiff.util.Diff;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;

public class DiffHighlight
extends TextAreaExtension {
    public static final Position LEFT = new Position();
    public static final Position RIGHT = new Position();
    private static HashMap<EditPane, TextAreaExtension> highlights = new HashMap();
    private JEditTextArea textArea;
    private boolean enabled = false;
    private Diff.Change edits;
    private Position position;

    private DiffHighlight(JEditTextArea jEditTextArea, Diff.Change change, Position position) {
        this.textArea = jEditTextArea;
        this.edits = change;
        this.position = position;
    }

    public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        block11: {
            if (!this.isEnabled()) break block11;
            if (this.textArea.getLineStartOffset(n2) == -1 || this.textArea.getLineEndOffset(n2) == -1) {
                return;
            }
            Diff.Change change = this.edits;
            if (this.position == LEFT) {
                while (change != null) {
                    if (change.first0 <= n2 && n2 <= change.last0) {
                        Color color;
                        int n6;
                        TextAreaPainter textAreaPainter = this.textArea.getPainter();
                        int n7 = n6 = change.lines0 == 0 ? n5 : textAreaPainter.getFontMetrics().getHeight();
                        if (change.lines0 != 0) {
                            color = change.lines1 == 0 ? JDiffPlugin.highlightDeletedColor : JDiffPlugin.highlightChangedColor;
                            graphics2D.setColor(color);
                            graphics2D.fillRect(0, n5, textAreaPainter.getWidth(), n6);
                            break;
                        }
                        if (change.first0 == n2) {
                            color = JDiffPlugin.highlightInvalidColor;
                            graphics2D.setColor(color);
                            graphics2D.drawLine(0, n5, textAreaPainter.getWidth() - 1, n6);
                        }
                    }
                    change = change.next;
                }
            } else {
                while (change != null) {
                    if (change.first1 <= n2 && n2 <= change.last1) {
                        Color color;
                        int n8;
                        TextAreaPainter textAreaPainter = this.textArea.getPainter();
                        int n9 = n8 = change.lines1 == 0 ? n5 : textAreaPainter.getFontMetrics().getHeight();
                        if (change.lines1 != 0) {
                            color = change.lines0 == 0 ? JDiffPlugin.highlightInsertedColor : JDiffPlugin.highlightChangedColor;
                            graphics2D.setColor(color);
                            graphics2D.fillRect(0, n5, textAreaPainter.getWidth(), n8);
                            break;
                        }
                        if (change.first1 == n2) {
                            color = JDiffPlugin.highlightInvalidColor;
                            graphics2D.setColor(color);
                            graphics2D.drawLine(0, n5, textAreaPainter.getWidth() - 1, n8);
                        }
                    }
                    change = change.next;
                }
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void toggleEnabled() {
        this.enabled = !this.enabled;
    }

    public Diff.Change getEdits() {
        return this.edits;
    }

    public void setEdits(Diff.Change change) {
        this.edits = change;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void updateTextArea() {
        if (this.textArea == null) {
            return;
        }
        int n = this.textArea.getFirstPhysicalLine();
        int n2 = n + this.textArea.getVisibleLines();
        this.textArea.invalidateLineRange(n, n2);
    }

    public static boolean isDiffHighlightEnabledFor(EditPane editPane) {
        DiffHighlight diffHighlight = (DiffHighlight)highlights.get(editPane);
        if (diffHighlight != null) {
            return diffHighlight.isEnabled();
        }
        return false;
    }

    public static void setDiffHighlightFor(EditPane editPane, boolean bl) {
        DiffHighlight diffHighlight = (DiffHighlight)highlights.get(editPane);
        if (diffHighlight != null) {
            diffHighlight.setEnabled(bl);
            diffHighlight.updateTextArea();
        }
    }

    public static void enableDiffHighlightFor(EditPane editPane) {
        DiffHighlight.setDiffHighlightFor(editPane, true);
    }

    public static void disableDiffHighlightFor(EditPane editPane) {
        DiffHighlight.setDiffHighlightFor(editPane, false);
    }

    public static TextAreaExtension getHighlightFor(EditPane editPane) {
        return highlights.get(editPane);
    }

    public static TextAreaExtension addHighlightTo(EditPane editPane, Diff.Change change, Position position) {
        DiffHighlight diffHighlight = new DiffHighlight(editPane.getTextArea(), change, position);
        highlights.put(editPane, diffHighlight);
        return diffHighlight;
    }

    public static void removeHighlightFrom(EditPane editPane) {
        highlights.remove(editPane);
    }

    public static class Position {
    }
}

