/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import jdiff.DiffMessage;
import jdiff.DualDiff;
import jdiff.component.PatchSelectionDialog;
import jdiff.util.Diff;
import jdiff.util.DiffNormalOutput;
import jdiff.util.DiffOutput;
import jdiff.util.DualDiffUtil;
import jdiff.util.JDiffDiff;
import jdiff.util.patch.Patch;
import jdiff.util.patch.PatchUtils;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public class DualDiffManager {
    public static final String JDIFF_LINES = "jdiff-lines";
    public static final String BEEP_ON_ERROR = "jdiff.beep-on-error";
    public static final String HORIZ_SCROLL = "jdiff.horiz-scroll";
    public static final String SELECT_WORD = "jdiff.select-word";
    private static HashMap<View, DualDiff> dualDiffs = new HashMap();
    private static HashMap<View, String> splitConfigs = new HashMap();
    private static HashMap<View, HashMap<String, List<Integer>>> caretPositions = new HashMap();

    public static DualDiff getDualDiffFor(View view) {
        return dualDiffs.get(view);
    }

    public static boolean isEnabledFor(View view) {
        return dualDiffs.get(view) != null;
    }

    public static void addTo(View view) {
        DualDiff dualDiff = new DualDiff(view);
        dualDiffs.put(view, dualDiff);
    }

    public static void removeFrom(View view) {
        dualDiffs.remove(view);
        splitConfigs.remove(view);
        caretPositions.remove(view);
        EditBus.send((EBMessage)new DiffMessage(view, DiffMessage.OFF));
    }

    private static void validateConfig(View view, String string) {
        if (string == null) {
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Pattern pattern = Pattern.compile("\"(.*?)\"");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            if (string2 == null || "global".equals(string2) || "view".equals(string2) || "editpane".equals(string2)) continue;
            hashSet.add(string2);
        }
        for (String string3 : hashSet) {
            if (jEdit.getBuffer((String)string3) != null) continue;
            JOptionPane.showMessageDialog((Component)view, "JDiff encountered this problem while restoring perspective:\n\nFile closed during diff:\n" + string3, "JDiff Error", 0);
        }
    }

    public static void toggleFor(View view) {
        if (DualDiffManager.isEnabledFor(view)) {
            DualDiffManager.toggleOffFor(view);
        } else {
            DualDiffManager.toggleOnFor(view);
        }
    }

    private static void toggleOffFor(View view) {
        String string = splitConfigs.get(view);
        HashMap<String, List<Integer>> hashMap = caretPositions.get(view);
        DualDiffManager.removeFrom(view);
        if (jEdit.getBooleanProperty((String)"jdiff.restore-view", (boolean)true)) {
            view.unsplit();
        }
        if (jEdit.getBooleanProperty((String)"jdiff.restore-caret", (boolean)true) && hashMap != null) {
            for (EditPane editPane : view.getEditPanes()) {
                List<Integer> list = hashMap.get(editPane.getBuffer().getPath());
                if (list == null) continue;
                JEditTextArea jEditTextArea = editPane.getTextArea();
                int n = Math.max(jEditTextArea.getBufferLength() - 1, 0);
                int n2 = Math.min(list.get(0), n);
                int n3 = jEditTextArea.getLineCount() - 1;
                int n4 = Math.min(list.get(1), n3);
                jEditTextArea.setCaretPosition(n2);
                jEditTextArea.setFirstPhysicalLine(n4);
            }
            hashMap = null;
        }
        view.invalidate();
        view.validate();
    }

    private static void toggleOnFor(View view) {
        EditPane[] editPaneArray;
        boolean bl = false;
        JSplitPane jSplitPane = view.getSplitPane();
        if (jSplitPane != null) {
            boolean bl2 = bl = jSplitPane.getOrientation() == 0;
        }
        if ((editPaneArray = view.getEditPanes()).length != 2 || bl) {
            view.unsplit();
            view.splitVertically();
        }
        editPaneArray = view.getEditPanes();
        HashMap hashMap = new HashMap();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(editPaneArray[0].getTextArea().getCaretPosition());
        arrayList.add(editPaneArray[0].getTextArea().getFirstPhysicalLine());
        hashMap.put(editPaneArray[0].getBuffer().getPath(), arrayList);
        arrayList = new ArrayList();
        arrayList.add(editPaneArray[1].getTextArea().getCaretPosition());
        arrayList.add(editPaneArray[1].getTextArea().getFirstPhysicalLine());
        hashMap.put(editPaneArray[1].getBuffer().getPath(), arrayList);
        caretPositions.put(view, hashMap);
        DualDiffManager.addTo(view);
        EditBus.send((EBMessage)new DiffMessage(view, DiffMessage.ON));
    }

    public static void refreshFor(View view) {
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        if (dualDiff != null) {
            dualDiff.refresh();
        } else if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
            view.getToolkit().beep();
        }
    }

    public static boolean getIgnoreCaseFor(View view) {
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        if (dualDiff == null) {
            return false;
        }
        return dualDiff.getIgnoreCase();
    }

    public static void toggleIgnoreCaseFor(View view) {
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        if (dualDiff != null) {
            dualDiff.toggleIgnoreCase();
            dualDiff.refresh();
        } else if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
            view.getToolkit().beep();
        }
    }

    public static boolean getTrimWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        if (dualDiff == null) {
            return false;
        }
        return dualDiff.getTrimWhitespace();
    }

    public static void toggleTrimWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        if (dualDiff != null) {
            dualDiff.toggleTrimWhitespace();
            dualDiff.refresh();
        } else if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
            view.getToolkit().beep();
        }
    }

    public static boolean getIgnoreAmountOfWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        if (dualDiff == null) {
            return false;
        }
        return dualDiff.getIgnoreAmountOfWhitespace();
    }

    public static void toggleIgnoreAmountOfWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        if (dualDiff != null) {
            dualDiff.toggleIgnoreAmountOfWhitespace();
            dualDiff.refresh();
        } else if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
            view.getToolkit().beep();
        }
    }

    public static boolean getIgnoreLineSeparatorsFor(View view) {
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        if (dualDiff == null) {
            return false;
        }
        return dualDiff.getIgnoreLineSeparators();
    }

    public static void toggleIgnoreLineSeparatorsFor(View view) {
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        if (dualDiff != null) {
            dualDiff.toggleIgnoreLineSeparators();
            dualDiff.refresh();
        } else if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
            view.getToolkit().beep();
        }
    }

    public static boolean getIgnoreAllWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        if (dualDiff == null) {
            return false;
        }
        return dualDiff.getIgnoreAllWhitespace();
    }

    public static void toggleIgnoreAllWhitespaceFor(View view) {
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        if (dualDiff != null) {
            dualDiff.toggleIgnoreAllWhitespace();
            dualDiff.refresh();
        } else if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
            view.getToolkit().beep();
        }
    }

    public static void nextDiff(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(editPane.getView());
        if (dualDiff == null) {
            if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
                editPane.getToolkit().beep();
            }
            return;
        }
        if (editPane.equals(dualDiff.getEditPane0())) {
            dualDiff.nextDiff0();
        } else if (editPane.equals(dualDiff.getEditPane1())) {
            dualDiff.nextDiff1();
        } else if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
            editPane.getToolkit().beep();
        }
    }

    public static void prevDiff(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(editPane.getView());
        if (dualDiff == null) {
            if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
                editPane.getToolkit().beep();
            }
            return;
        }
        if (editPane.equals(dualDiff.getEditPane0())) {
            dualDiff.prevDiff0();
        } else if (editPane.equals(dualDiff.getEditPane1())) {
            dualDiff.prevDiff1();
        } else if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
            editPane.getToolkit().beep();
        }
    }

    public static void moveRight(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(editPane.getView());
        if (dualDiff == null) {
            if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
                editPane.getToolkit().beep();
            }
            return;
        }
        dualDiff.moveRight(editPane);
    }

    public static void moveLeft(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(editPane.getView());
        if (dualDiff == null) {
            editPane.getToolkit().beep();
            return;
        }
        dualDiff.moveLeft(editPane);
    }

    public static void moveMultipleRight(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(editPane.getView());
        if (dualDiff == null) {
            if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
                editPane.getToolkit().beep();
            }
            return;
        }
        dualDiff.moveMultipleRight(editPane);
    }

    public static void moveMultipleLeft(EditPane editPane) {
        if (editPane == null) {
            return;
        }
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(editPane.getView());
        if (dualDiff == null) {
            editPane.getToolkit().beep();
            return;
        }
        dualDiff.moveMultipleLeft(editPane);
    }

    public static void diffNormalOutput(View view) {
        View view2;
        Object[] objectArray;
        if (!DualDiffManager.isEnabledFor(view)) {
            if (jEdit.getBooleanProperty((String)BEEP_ON_ERROR)) {
                view.getToolkit().beep();
            }
            return;
        }
        DualDiff dualDiff = DualDiffManager.getDualDiffFor(view);
        Buffer buffer = dualDiff.getEditPane0().getBuffer();
        Buffer buffer2 = dualDiff.getEditPane1().getBuffer();
        Object[] objectArray2 = DualDiffUtil.getFileLines(dualDiff, buffer);
        JDiffDiff jDiffDiff = new JDiffDiff(objectArray2, objectArray = DualDiffUtil.getFileLines(dualDiff, buffer2));
        Diff.Change change = jDiffDiff.diff_2();
        if (change == null) {
            GUIUtilities.message((Component)view, (String)"jdiff.identical-files", null);
            return;
        }
        StringWriter stringWriter = new StringWriter();
        DiffNormalOutput diffNormalOutput = new DiffNormalOutput(objectArray2, objectArray);
        diffNormalOutput.setOut(new BufferedWriter(stringWriter));
        diffNormalOutput.setLineSeparator("\n");
        try {
            ((DiffOutput)diffNormalOutput).writeScript(change);
        }
        catch (IOException iOException) {
            Log.log((int)1, DualDiff.class, (Object)iOException);
        }
        for (view2 = jEdit.getFirstView(); view2 != null && DualDiffManager.isEnabledFor(view2); view2 = view2.getNext()) {
        }
        if (view2 == null) {
            view2 = jEdit.newView((View)view, (Buffer)view.getBuffer());
        }
        Buffer buffer3 = jEdit.newFile((View)view2);
        String string = stringWriter.toString();
        buffer3.insert(0, string);
        if (string.endsWith("\n") && buffer3.getLength() > 0) {
            buffer3.remove(buffer3.getLength() - 1, 1);
        }
    }

    public static void applyPatch(View view) {
        try {
            PatchSelectionDialog patchSelectionDialog = new PatchSelectionDialog(view);
            DualDiffUtil.center((Component)view, patchSelectionDialog);
            patchSelectionDialog.setVisible(true);
            String string = patchSelectionDialog.getPatchFile();
            if (string == null || string.length() == 0) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            StringWriter stringWriter = new StringWriter();
            PatchUtils.copyToWriter(bufferedReader, stringWriter);
            String string2 = stringWriter.toString();
            if (string2 == null || string2.length() == 0) {
                JOptionPane.showMessageDialog((Component)view, "Invalid patch file, file has no content.", "Error", 0);
                return;
            }
            Buffer buffer = view.getEditPane().getBuffer();
            String string3 = buffer.getText(0, buffer.getLength());
            String string4 = Patch.patch(string2, string3);
            jEdit.newFile((View)view).insert(0, string4);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)view, exception.getMessage(), "Error", 0);
        }
    }
}

