/*
 * Decompiled with CFR 0.152.
 */
package jdiff.component;

import javax.swing.JComponent;
import jdiff.DualDiff;
import jdiff.component.DiffTextAreaModel;
import jdiff.util.Diff;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public abstract class DiffOverview
extends JComponent {
    protected DualDiff dualDiff;
    private DiffTextAreaModel model = null;
    protected Diff.Change edits;
    protected int lineCount0;
    protected int lineCount1;
    protected JEditTextArea textArea0;
    protected JEditTextArea textArea1;

    public DiffOverview() {
        this(null);
    }

    public DiffOverview(DualDiff dualDiff) {
        this.dualDiff = dualDiff;
        this.setModel(new DiffTextAreaModel(dualDiff));
    }

    public void setModel(DiffTextAreaModel diffTextAreaModel) {
        this.model = diffTextAreaModel;
        this.edits = diffTextAreaModel.getEdits();
        this.lineCount0 = diffTextAreaModel.getLeftLineCount();
        this.lineCount1 = diffTextAreaModel.getRightLineCount();
        this.textArea0 = diffTextAreaModel.getLeftTextArea();
        this.textArea1 = diffTextAreaModel.getRightTextArea();
    }

    public DiffTextAreaModel getModel() {
        return this.model;
    }

    public void synchroScrollRight() {
        if (!jEdit.getBooleanProperty((String)"jdiff.synchroscroll-on", (boolean)true)) {
            return;
        }
        Diff.Change change = this.edits;
        int n = this.textArea0.getFirstPhysicalLine();
        int n2 = this.textArea1.getFirstLine();
        int n3 = this.textArea1.getLineCount() - this.textArea1.getVisibleLines() + 1;
        if (change == null) {
            this.goToLine(this.textArea1, Math.min(n, n3));
            return;
        }
        while (change != null) {
            if (n < change.first0 && change.prev == null) {
                this.goToLine(this.textArea1, n);
                return;
            }
            if (n >= change.first0 && n < change.first0 + change.lines0) {
                int n4 = 0;
                if (change.lines0 == 0 && change.lines1 > 0) {
                    n4 = n2 - change.first1;
                } else if (change.lines0 > 0 && change.lines1 == 0) {
                    n4 = 0;
                } else if (change.lines0 == change.lines1) {
                    n4 = n - change.first0;
                } else if (change.lines0 > change.lines1) {
                    int n5 = change.lines0 / change.lines1;
                    int n6 = Math.round((float)(change.lines1 * n5) / (float)change.lines0);
                    n4 = (n - change.first0) / n5 * n6;
                } else if (change.lines0 < change.lines1) {
                    int n7 = change.lines1 / change.lines0;
                    int n8 = Math.round((float)(change.lines0 * n7) / (float)change.lines1);
                    n4 = (n - change.first0) / n8 * n7;
                } else {
                    return;
                }
                this.goToLine(this.textArea1, change.first1 + n4);
                return;
            }
            if (n > change.last0 && change.next != null && n < change.next.first0) {
                int n9 = n - change.last0;
                this.goToLine(this.textArea1, change.last1 + n9);
                return;
            }
            if (n > change.last0 && change.next == null) {
                int n10 = n - change.last0;
                this.goToLine(this.textArea1, change.last1 + n10);
                return;
            }
            change = change.next;
        }
    }

    public void synchroScrollLeft() {
        if (!jEdit.getBooleanProperty((String)"jdiff.synchroscroll-on", (boolean)true)) {
            return;
        }
        Diff.Change change = this.edits;
        int n = this.textArea0.getFirstLine();
        int n2 = this.textArea1.getFirstPhysicalLine();
        int n3 = this.textArea0.getLineCount() - this.textArea0.getVisibleLines() + 1;
        if (change == null) {
            this.goToLine(this.textArea0, Math.min(n2, n3));
            return;
        }
        while (change != null) {
            if (n2 < change.first1 && change.prev == null) {
                this.goToLine(this.textArea0, n2);
                return;
            }
            if (n2 >= change.first1 && n2 < change.first1 + change.lines1) {
                int n4 = 0;
                if (change.lines1 == 0 && change.lines0 > 0) {
                    n4 = n - change.first0;
                } else if (change.lines1 > 0 && change.lines0 == 0) {
                    n4 = 0;
                } else if (change.lines1 == change.lines0) {
                    n4 = n2 - change.first1;
                } else if (change.lines1 > change.lines0) {
                    int n5 = change.lines1 / change.lines0;
                    int n6 = Math.round((float)(change.lines0 * n5) / (float)change.lines1);
                    n4 = (n2 - change.first1) / n5 * n6;
                } else if (change.lines1 < change.lines0) {
                    int n7 = change.lines0 / change.lines1;
                    int n8 = Math.round((float)(change.lines1 * n7) / (float)change.lines0);
                    n4 = (n2 - change.first1) / n8 * n7;
                } else {
                    return;
                }
                this.goToLine(this.textArea0, change.first0 + n4);
                return;
            }
            if (n2 > change.last1 && change.next != null && n2 < change.next.first1) {
                int n9 = n2 - change.last1;
                this.goToLine(this.textArea0, change.last0 + n9);
                return;
            }
            if (n2 > change.last1 && change.next == null) {
                int n10 = n2 - change.last1;
                this.goToLine(this.textArea0, change.last0 + n10);
                return;
            }
            change = change.next;
        }
    }

    void goToLine(JEditTextArea jEditTextArea, int n) {
        int n2;
        if (jEdit.getActiveView().getTextArea().equals(jEditTextArea)) {
            return;
        }
        int n3 = n;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= jEditTextArea.getLineCount()) {
            n3 = jEditTextArea.getLineCount() - 1;
        }
        jEditTextArea.setFirstPhysicalLine(n3);
        if ((jEditTextArea.getWidth() != 0 || jEditTextArea.getHeight() != 0 || jEditTextArea.getX() != 0 || jEditTextArea.getY() != 0) && (n2 = jEditTextArea.getScreenLineStartOffset(jEditTextArea.getVisibleLines() / 2)) != -1) {
            jEditTextArea.centerCaret();
        }
    }

    public void moveRight(int n) {
    }

    public void moveLeft(int n) {
    }
}

