/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import jdiff.DualDiff;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.TextArea;

public class ScrollHandler
implements ScrollListener,
FocusListener,
MouseListener {
    private DualDiff parent = null;
    private Runnable syncWithRightVert;
    private Runnable syncWithLeftVert;
    private Runnable syncWithRightHoriz;
    private Runnable syncWithLeftHoriz;

    public ScrollHandler(DualDiff dualDiff) {
        if (dualDiff == null) {
            throw new IllegalArgumentException("Constructor must have valid DualDiff parameter.");
        }
        this.parent = dualDiff;
        this.syncWithRightVert = new Runnable(){

            public void run() {
                ScrollHandler.this.parent.getDiffOverview0().repaint();
                ScrollHandler.this.parent.getDiffOverview0().synchroScrollRight();
                ScrollHandler.this.parent.getDiffOverview1().repaint();
            }
        };
        this.syncWithLeftVert = new Runnable(){

            public void run() {
                ScrollHandler.this.parent.getDiffOverview1().repaint();
                ScrollHandler.this.parent.getDiffOverview1().synchroScrollLeft();
                ScrollHandler.this.parent.getDiffOverview0().repaint();
            }
        };
        this.syncWithRightHoriz = new Runnable(){

            public void run() {
                ScrollHandler.this.parent.getTextArea1().setHorizontalOffset(ScrollHandler.this.parent.getTextArea0().getHorizontalOffset());
            }
        };
        this.syncWithLeftHoriz = new Runnable(){

            public void run() {
                ScrollHandler.this.parent.getTextArea0().setHorizontalOffset(ScrollHandler.this.parent.getTextArea1().getHorizontalOffset());
            }
        };
    }

    public void scrolledHorizontally(TextArea textArea) {
        if (textArea == this.parent.getTextArea0()) {
            SwingUtilities.invokeLater(this.syncWithRightHoriz);
        } else if (textArea == this.parent.getTextArea1()) {
            SwingUtilities.invokeLater(this.syncWithLeftHoriz);
        }
    }

    public void scrolledVertically(TextArea textArea) {
        if (textArea == this.parent.getTextArea0()) {
            SwingUtilities.invokeLater(this.syncWithRightVert);
        } else if (textArea == this.parent.getTextArea1()) {
            SwingUtilities.invokeLater(this.syncWithLeftVert);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (jEdit.getBooleanProperty((String)"jdiff.auto-show-dockable") && !this.parent.getView().getDockableWindowManager().isDockableWindowVisible("jdiff-lines")) {
            this.parent.getView().getDockableWindowManager().showDockableWindow("jdiff-lines");
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

