/*
 * Decompiled with CFR 0.152.
 */
package jdiff.util.patch.normal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTools {
    public static String arrayToString(Object[] objectArray) {
        return StringTools.arrayToString(objectArray, "\n");
    }

    public static String arrayToString(Object[] objectArray, String string) {
        if (objectArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(objectArray[i].toString()).append(string);
        }
        return stringBuilder.toString().substring(0, stringBuilder.toString().length() - string.length());
    }

    public static String stringToStringBuilderCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StringBuilder sb = new StringBuilder();\n");
        String[] stringArray = StringTools.stringToArray(string, "\n");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("sb.append(\"" + stringArray[i] + "\\n\");\n");
        }
        return stringBuilder.toString();
    }

    public static String firstLetterUpperCaseOfEachWord(String string) {
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (stringArray[i].charAt(0) + "").toUpperCase() + stringArray[i].substring(1, stringArray[i].length());
            if (i >= stringArray.length - 1) continue;
            int n = i;
            stringArray[n] = stringArray[n] + " ";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String getFormatedStringOfBytes(byte[] byArray, String string, int n) {
        String string2 = StringTools.getFormatedStringOfBytes(byArray, string);
        if (string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static String getFormatedStringOfBytes(byte[] byArray, String string) {
        if (string.equals("box")) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                if (i > 0 && i % 8 == 0) {
                    stringBuilder.append('\n' + StringTools.getStringOfByte(byArray[i]));
                    continue;
                }
                if (i == 0) {
                    stringBuilder.append(StringTools.getStringOfByte(byArray[i]));
                    continue;
                }
                stringBuilder.append(' ' + StringTools.getStringOfByte(byArray[i]));
            }
            return stringBuilder.toString();
        }
        if (string.equals("dotted")) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length - 1; ++i) {
                stringBuilder.append(StringTools.getStringOfByte(byArray[i]) + ":");
            }
            if (byArray.length > 0) {
                stringBuilder.append(StringTools.getStringOfByte(byArray[byArray.length - 1]));
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(StringTools.getStringOfByte(byArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String getStringOfByte(byte n) {
        String string;
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        if ((string = Integer.toHexString(n2).toUpperCase()).length() == 1) {
            string = '0' + string;
        }
        return string;
    }

    public static String lineBreakAfterNchars(String string, int n) {
        int n2 = 0;
        int n3 = --n;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (i % n != 0) continue;
            if (string.length() - n3 < 0) {
                n3 = string.length();
                stringBuilder.append(string.substring(n2, n3));
            } else {
                stringBuilder.append(string.substring(n2, n3) + "\n");
            }
            n2 = n3;
            n3 += n;
        }
        return stringBuilder.toString();
    }

    public static String readFileIntoString(File file) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append("\n" + string);
        }
        bufferedReader.close();
        return stringBuilder.toString().substring(1);
    }

    public static String[] readFileIntoStringArray(String string) {
        try {
            return StringTools.stringToArray(StringTools.readFileIntoString(new File(string)));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String[] stringToArray(String string) {
        return StringTools.stringToArray(string, "\n");
    }

    public static String[] stringToArray(String string, String string2) {
        ArrayList<String> arrayList = StringTools.stringToArrayList(string, string2);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static ArrayList<String> stringToArrayList(String string) {
        return StringTools.stringToArrayList(string, "\n");
    }

    public static ArrayList<String> stringToArrayList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string2) && bl) {
                arrayList.add("");
                bl = true;
                continue;
            }
            if (string3.equals(string2) && !bl) {
                bl = true;
                continue;
            }
            arrayList.add(string3);
            bl = false;
        }
        return arrayList;
    }

    public static void writeStringIntoFile(String string, File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string);
        bufferedWriter.close();
    }

    public static String removeLineBreaks(String string) {
        String string2 = string.replace("\n", " ");
        string2 = string2.replace("\r\n", " ");
        string2 = string2.replace("\n\r", " ");
        string2 = string2.replace("\r", " ");
        return string2;
    }

    public static String removeLineBreaks(String string, int n) {
        String string2 = StringTools.removeLineBreaks(string);
        if (string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private StringTools() {
    }

    public static void main(String[] stringArray) {
    }
}

