#!/bin/sh

log=/var/log/clamav/clamscan.log 
echo ========================================= | tee -a ${log}
date | tee -a ${log}
hostname | tee -a ${log}

# サービスまたはcronで定期的に更新されるのでここではfreshclamしない
# freshclam

# デーモン(clamd)を使っている場合は、clamscanでなく、clamdscanを使う
# clamdscan / \

clamscan / \
     --infected \
     --recursive \
     --log=${log} \
     --move=/var/log/clamav/virus \
     --exclude-dir=^/boot \
     --exclude-dir=^/sys \
     --exclude-dir=^/proc \
     --exclude-dir=^/dev \
     --exclude-dir=^/var/log/clamav/virus

# --infected 感染を検出したファイルのみを結果に出力
# --recursive 指定ディレクトリ以下を再帰的に検査 圧縮ファイルは解凍して検査
# --log=FILE ログファイル
# --move=DIR 感染を検出したファイルの隔離先
# --remove 感染を検出したファイルを削除
# --exclude=FILE 　　検査除外ファイル（パターンで指定）
# --exclude-dir=DIR　検査除外ディレクトリ（パターンで指定）

if [ $? = 0 ]; then
  echo "ウイルス未検出." | tee -a ${log}
else
  echo "ウイルス検出!!" | tee -a ${log}
fi
