/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)BooleanDataType.class);

    BooleanDataType() {
        this("BOOLEAN", 16);
    }

    BooleanDataType(String name, int sqlType) {
        super(name, sqlType, Boolean.class, false);
    }

    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (number.intValue() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (value instanceof String) {
            String string = (String)value;
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
                return Boolean.valueOf(string);
            }
            return this.typeCast(DataType.INTEGER.typeCast(string));
        }
        throw new TypeCastException(value, this);
    }

    protected int compareNonNulls(Object value1, Object value2) throws TypeCastException {
        logger.debug("compareNonNulls(value1={}, value2={}) - start", value1, value2);
        Boolean value1bool = (Boolean)value1;
        Boolean value2bool = (Boolean)value2;
        if (value1bool.equals(value2bool)) {
            return 0;
        }
        if (value1bool.equals(Boolean.FALSE)) {
            return -1;
        }
        return 1;
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        boolean value = resultSet.getBoolean(column);
        if (resultSet.wasNull()) {
            return null;
        }
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        Boolean castValue;
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        if ((castValue = (Boolean)this.typeCast(value)) == null) {
            statement.setNull(column, 16);
        } else {
            statement.setBoolean(column, castValue);
        }
    }
}

