/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.CloseConnectionOperation;
import org.dbunit.operation.CompositeOperation;
import org.dbunit.operation.DeleteAllOperation;
import org.dbunit.operation.DeleteOperation;
import org.dbunit.operation.InsertOperation;
import org.dbunit.operation.RefreshOperation;
import org.dbunit.operation.TransactionOperation;
import org.dbunit.operation.TruncateTableOperation;
import org.dbunit.operation.UpdateOperation;

public abstract class DatabaseOperation {
    public static final DatabaseOperation NONE = new DummyOperation();
    public static final DatabaseOperation UPDATE = new UpdateOperation();
    public static final DatabaseOperation INSERT = new InsertOperation();
    public static final DatabaseOperation REFRESH = new RefreshOperation();
    public static final DatabaseOperation DELETE = new DeleteOperation();
    public static final DatabaseOperation DELETE_ALL = new DeleteAllOperation();
    public static final DatabaseOperation TRUNCATE_TABLE = new TruncateTableOperation();
    public static final DatabaseOperation CLEAN_INSERT = new CompositeOperation(DELETE_ALL, INSERT);

    public static final DatabaseOperation TRANSACTION(DatabaseOperation operation) {
        return new TransactionOperation(operation);
    }

    public static final DatabaseOperation CLOSE_CONNECTION(DatabaseOperation operation) {
        return new CloseConnectionOperation(operation);
    }

    public abstract void execute(IDatabaseConnection var1, IDataSet var2) throws DatabaseUnitException, SQLException;

    private static class DummyOperation
    extends DatabaseOperation {
        private DummyOperation() {
        }

        public void execute(IDatabaseConnection connection, IDataSet dataSet) {
        }
    }
}

