/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Sumproduct
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        int maxN = args.length;
        if (maxN < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        Eval firstArg = args[0];
        try {
            if (firstArg instanceof NumericValueEval) {
                return Sumproduct.evaluateSingleProduct(args);
            }
            if (firstArg instanceof RefEval) {
                return Sumproduct.evaluateSingleProduct(args);
            }
            if (firstArg instanceof AreaEval) {
                AreaEval ae = (AreaEval)firstArg;
                if (ae.isRow() && ae.isColumn()) {
                    return Sumproduct.evaluateSingleProduct(args);
                }
                return Sumproduct.evaluateAreaSumProduct(args);
            }
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        throw new RuntimeException("Invalid arg type for SUMPRODUCT: (" + firstArg.getClass().getName() + ")");
    }

    private static Eval evaluateSingleProduct(Eval[] evalArgs) throws EvaluationException {
        int maxN = evalArgs.length;
        double term = 1.0;
        for (int n = 0; n < maxN; ++n) {
            double val = Sumproduct.getScalarValue(evalArgs[n]);
            term *= val;
        }
        return new NumberEval(term);
    }

    private static double getScalarValue(Eval arg) throws EvaluationException {
        Eval eval;
        if (arg instanceof RefEval) {
            RefEval re = (RefEval)arg;
            eval = re.getInnerValueEval();
        } else {
            eval = arg;
        }
        if (eval == null) {
            throw new RuntimeException("parameter may not be null");
        }
        if (eval instanceof AreaEval) {
            AreaEval ae = (AreaEval)eval;
            if (!ae.isColumn() || !ae.isRow()) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            eval = ae.getRelativeValue(0, 0);
        }
        if (!(eval instanceof ValueEval)) {
            throw new RuntimeException("Unexpected value eval class (" + eval.getClass().getName() + ")");
        }
        return Sumproduct.getProductTerm((ValueEval)eval, true);
    }

    private static Eval evaluateAreaSumProduct(Eval[] evalArgs) throws EvaluationException {
        int maxN = evalArgs.length;
        AreaEval[] args = new AreaEval[maxN];
        try {
            System.arraycopy(evalArgs, 0, args, 0, maxN);
        }
        catch (ArrayStoreException e) {
            return ErrorEval.VALUE_INVALID;
        }
        AreaEval firstArg = args[0];
        int height = firstArg.getHeight();
        int width = firstArg.getWidth();
        if (!Sumproduct.areasAllSameSize(args, height, width)) {
            for (int i = 1; i < args.length; ++i) {
                Sumproduct.throwFirstError(args[i]);
            }
            return ErrorEval.VALUE_INVALID;
        }
        double acc = 0.0;
        for (int rrIx = 0; rrIx < height; ++rrIx) {
            for (int rcIx = 0; rcIx < width; ++rcIx) {
                double term = 1.0;
                for (int n = 0; n < maxN; ++n) {
                    double val = Sumproduct.getProductTerm(args[n].getRelativeValue(rrIx, rcIx), false);
                    term *= val;
                }
                acc += term;
            }
        }
        return new NumberEval(acc);
    }

    private static void throwFirstError(AreaEval areaEval) throws EvaluationException {
        int height = areaEval.getHeight();
        int width = areaEval.getWidth();
        for (int rrIx = 0; rrIx < height; ++rrIx) {
            for (int rcIx = 0; rcIx < width; ++rcIx) {
                ValueEval ve = areaEval.getRelativeValue(rrIx, rcIx);
                if (!(ve instanceof ErrorEval)) continue;
                throw new EvaluationException((ErrorEval)ve);
            }
        }
    }

    private static boolean areasAllSameSize(AreaEval[] args, int height, int width) {
        for (int i = 0; i < args.length; ++i) {
            AreaEval areaEval = args[i];
            if (areaEval.getHeight() != height) {
                return false;
            }
            if (areaEval.getWidth() == width) continue;
            return false;
        }
        return true;
    }

    private static double getProductTerm(ValueEval ve, boolean isScalarProduct) throws EvaluationException {
        if (ve instanceof BlankEval || ve == null) {
            if (isScalarProduct) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return 0.0;
        }
        if (ve instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)ve);
        }
        if (ve instanceof StringEval) {
            if (isScalarProduct) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return 0.0;
        }
        if (ve instanceof NumericValueEval) {
            NumericValueEval nve = (NumericValueEval)ve;
            return nve.getNumberValue();
        }
        throw new RuntimeException("Unexpected value eval class (" + ve.getClass().getName() + ")");
    }
}

