<?php

  use Illuminate\Support\Facades\Route;

  /*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | Here is where you can register web routes for your application. These
  | routes are loaded by the RouteServiceProvider within a group which
  | contains the "web" middleware group. Now create something great!
  |
  */
  Route::group(['middleware' => 'verified'], function() {
      Route::get('/folders/{id}/tasks', 'App\Http\Controllers\TaskController@index')->name('tasks.index');

      Route::get('/folders/create', 'App\Http\Controllers\FolderController@showCreateForm')->name('folders.create');
      Route::post('/folders/create', 'App\Http\Controllers\FolderController@create');

      Route::get('/folders/{id}/tasks/create', 'App\Http\Controllers\TaskController@showCreateForm')->name('tasks.create');
      Route::post('/folders/{id}/tasks/create', 'App\Http\Controllers\TaskController@create');

      Route::get('/folders/{id}/tasks/{task_id}/edit', 'App\Http\Controllers\TaskController@showEditForm')->name('tasks.edit');
      Route::post('/folders/{id}/tasks/{task_id}/edit', 'App\Http\Controllers\TaskController@edit');

      Route::get('/', 'App\Http\Controllers\HomeController@index')->name('home');
  });

  Route::get('/dashboard', function () {
      return view('dashboard');
  })->middleware(['verified'])->name('dashboard');

  require __DIR__.'/auth.php';
  require __DIR__.'/my-auth.php';
