package jsf_test;

import java.io.Serializable;
import java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

@javax.faces.bean.ManagedBean  // マネージドBeanであることを宣言するアノテーション
@javax.faces.bean.SessionScoped // このマネージドBeanがsessionスコープであることを表すアノテーション


public class GameBean implements Serializable {
  public int getServerNumber1() {
		return serverNumber1;
	}
	
	public void setServerNumber1(int serverNumber1) {
		this.serverNumber1 = serverNumber1;
	}
	
	public int getServerNumber2() {
		return serverNumber2;
	}
	
	public void setServerNumber2(int serverNumber2) {
		this.serverNumber2 = serverNumber2;
	}
	
	public int getServerNumber3() {
		return serverNumber3;
	}
	
	public void setServerNumber3(int serverNumber3) {
		this.serverNumber3 = serverNumber3;
	}
	
	public Integer getUserNumber1() {
		return userNumber1;
	}
	
	public void setUserNumber1(Integer userNumber1) {
		this.userNumber1 = userNumber1;
	}
	
	public Integer getUserNumber2() {
		return userNumber2;
	}
	
	public void setUserNumber2(Integer userNumber2) {
		this.userNumber2 = userNumber2;
	}
	
	public Integer getUserNumber3() {
		return userNumber3;
	}
	
	public void setUserNumber3(Integer userNumber3) {
		this.userNumber3 = userNumber3;
	}
	
	public List<Answer> getHistory() {
		return history;
	}
	
	public void setHistory(List<Answer> history) {
		this.history = history;
	}
	
	public void setHint(String hint) {
		this.hint = hint;
	}
	
	private int serverNumber1; // 正解の数字 1
  private int serverNumber2; // 正解の数字 2
  private int serverNumber3; // 正解の数字 3
  
  private Integer userNumber1 = null; // ユーザーが回答した数字 1
  private Integer userNumber2 = null; // ユーザーが回答した数字 2
  private Integer userNumber3 = null; // ユーザーが回答した数字 3
  
  private String hint = "3つの数字を入力してください"; // 正解/不正解をユーザーに知らせるヒント
  private List<Answer> history = new ArrayList<Answer>(); // 回答履歴を保存するためのリスト
  
  private int num;
  
  // コンストラクタ
  public GameBean() {
    List<Integer> list = new ArrayList<Integer>(10);
    for (int i=0; i<10; i++) { list.add(i); }
    Collections.shuffle(list);
    serverNumber1 = list.get(0);
    serverNumber2 = list.get(1);
    serverNumber3 = list.get(2);
    num = 0;
  }
  /* 各プロパティの getter/setter メソッドを追加します。
  * Eclipse では、ソース・エディタを右クリックし、「Source」→「Generate Getters and Setters」を
  * 選択するとプロパティの getter メソッドと setter メソッドを生成することができます。*/
  
  public Object checkAnswer() {
    if (userNumber1 == userNumber2 ||  userNumber1 == userNumber3 ||
      userNumber2 == userNumber3) 
    {
      hint = "3つの数字を入力してください"; // ヒントを変更
      // メッセージ・バンドルの基底名を取得
      FacesContext ctx = FacesContext.getCurrentInstance();
      Application app = ctx.getApplication();
      String messageBundle = app.getMessageBundle();
      // Localeを取得
      UIViewRoot viewRoot = ctx.getViewRoot();
      Locale locale = viewRoot.getLocale();
      // エラー・メッセージをリソース・バンドルから取得
      ResourceBundle res = ResourceBundle.getBundle(messageBundle, locale);
      String errorMessage = res.getString("jsfsample.GameBean.DUPLICATE");
      // エラー・メッセージの生成
      FacesMessage message = new FacesMessage(errorMessage);
      message.setSeverity(FacesMessage.SEVERITY_ERROR); // メッセージの深刻度
      ctx.addMessage(null, message);
      return null;
    }
    
    int hit = 0;
    int blow = 0;
    hint = "テストメッセージ";
    System.out.println(hint);
    if (userNumber1.intValue() == serverNumber1) {
      hit ++;
    }
    if (userNumber2.intValue() == serverNumber2) {
      hit ++;
    }
    if (userNumber3.intValue() == serverNumber3) {
      hit ++;
    }
    if (hit == 3) {
      hint = "正解です！";
    } else {
      if (userNumber1.intValue() == serverNumber2 || 
        userNumber1.intValue() == serverNumber3) 
      {
        blow ++;
      }
      if (userNumber2.intValue() == serverNumber1 ||
        userNumber2.intValue() == serverNumber3) 
      {
        blow ++;
      }
      if (userNumber3.intValue() == serverNumber1 ||
        userNumber3.intValue() == serverNumber2) 
      {
        blow ++;
      }
      hint = "不正解です！ Hit:" + hit + " Blow:" + blow;
    }
    Answer answer = new Answer(userNumber1, userNumber2, userNumber3, hit, blow, num++);
    history.add(0,answer);
    
    return null;
  }
  
  public String getHint(){
    return hint;
  }
  
}