/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.filter.AbstractTableFilter;
import org.dbunit.dataset.filter.ExcludeTableFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.IncludeTableFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableFilter
extends AbstractTableFilter
implements ITableFilter {
    private static final Logger logger = LoggerFactory.getLogger((Class)DefaultTableFilter.class);
    private final IncludeTableFilter _includeFilter = new IncludeTableFilter();
    private final ExcludeTableFilter _excludeFilter = new ExcludeTableFilter();

    public void includeTable(String patternName) {
        logger.debug("includeTable(patternName=" + patternName + ") - start");
        this._includeFilter.includeTable(patternName);
    }

    public void excludeTable(String patternName) {
        logger.debug("excludeTable(patternName=" + patternName + ") - start");
        this._excludeFilter.excludeTable(patternName);
    }

    public boolean isValidName(String tableName) throws DataSetException {
        logger.debug("isValidName(tableName=" + tableName + ") - start");
        if (this._includeFilter.isEmpty() || this._includeFilter.accept(tableName)) {
            return this._excludeFilter.accept(tableName);
        }
        return false;
    }
}

