package trim;

import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.datatype.StringDataType;

public class TrimTable implements ITable {
  protected ITable table;
  protected ITableMetaData metaData;
  
  public TrimTable(ITable table){
    this.table = table;
    this.metaData = table.getTableMetaData();
  }
  
  public int getRowCount() {
    return table.getRowCount();
  }
  
  public ITableMetaData getTableMetaData() {
    return metaData;
  }
  
  public Object getValue(int row, String columnName) throws DataSetException {
    // Column[] columns = metaData.getColumns();
    // Column column = columns[metaData.getColumnIndex(columnName)];
    Object value = table.getValue(row, columnName);
    
    // if (column.getDataType() instanceof StringDataType && value != null) {
    if (value instanceof String) {
      value = rtrim((String)value, " ");
      // System.out.println("["+value+"]");
    }
    
    return value;
  }
  
  private static String rtrim(String str, String del){
    int start = 0;
    int end = str.length();
    int length = del.length();
    if (length == 0){
      return str;
    }
    
    while(start <= end - length){
      if (str.substring(end - length, end).equals(del)){
        end -= length;
      } else {
        break;
      }
    }
    return str.substring(start, end);
  }
}