/*
 *
 * The DbUnit Database Testing Framework
 * Copyright (C)2002-2008, DbUnit.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package org.dbunit.ext.oracle;

import java.sql.SQLException;
import java.sql.Connection;
import oracle.jdbc.OracleTypes;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.jpub.runtime.MutableStruct;

/**
 * This class was generated by oracle jpub.
 *
 * @see OracleSdoGeometryDataType
 * @author clucas@e-miles.com
 * @author Last changed by: $Author$
 * @version $Revision$ $Date$
 * @since ?
 */
public class OracleSdoPointType implements ORAData, ORADataFactory
{
  public static final String _SQL_NAME = "MDSYS.SDO_POINT_TYPE";
  public static final int _SQL_TYPECODE = OracleTypes.STRUCT;

  protected MutableStruct _struct;

  protected static int[] _sqlType =  { 2,2,2 };
  protected static ORADataFactory[] _factory = new ORADataFactory[3];
  protected static final OracleSdoPointType _OracleSdoPointTypeFactory = new OracleSdoPointType();

  public static ORADataFactory getORADataFactory()
  { return _OracleSdoPointTypeFactory; }
  /* constructors */
  protected void _init_struct(boolean init)
  { if (init) _struct = new MutableStruct(new Object[3], _sqlType, _factory); }
  public OracleSdoPointType()
  { _init_struct(true); }
  public OracleSdoPointType(java.math.BigDecimal x, java.math.BigDecimal y, java.math.BigDecimal z) throws SQLException
  { _init_struct(true);
    setX(x);
    setY(y);
    setZ(z);
  }

  /* ORAData interface */
  public Datum toDatum(Connection c) throws SQLException
  {
    return _struct.toDatum(c, _SQL_NAME);
  }


  /* ORADataFactory interface */
  public ORAData create(Datum d, int sqlType) throws SQLException
  { return create(null, d, sqlType); }
  protected ORAData create(OracleSdoPointType o, Datum d, int sqlType) throws SQLException
  {
    if (d == null) return null; 
    if (o == null) o = new OracleSdoPointType();
    o._struct = new MutableStruct((STRUCT) d, _sqlType, _factory);
    return o;
  }
  /* accessor methods */
  public java.math.BigDecimal getX() throws SQLException
  { return (java.math.BigDecimal) _struct.getAttribute(0); }

  public void setX(java.math.BigDecimal x) throws SQLException
  { _struct.setAttribute(0, x); }


  public java.math.BigDecimal getY() throws SQLException
  { return (java.math.BigDecimal) _struct.getAttribute(1); }

  public void setY(java.math.BigDecimal y) throws SQLException
  { _struct.setAttribute(1, y); }


  public java.math.BigDecimal getZ() throws SQLException
  { return (java.math.BigDecimal) _struct.getAttribute(2); }

  public void setZ(java.math.BigDecimal z) throws SQLException
  { _struct.setAttribute(2, z); }

  public String toString()
  { try {
     return "MDSYS.SDO_POINT_TYPE" + "(" +
       getX() + "," +
       getY() + "," +
       getZ() +
     ")";
    } catch (Exception e) { return e.toString(); }
  }

    public boolean equals(Object obj)
    {
        if (this == obj)
        {
            return true;
        }

        if ((obj == null) || (! obj.getClass().equals(this.getClass())))
        {
            return false;
        }

        OracleSdoPointType otherObject = (OracleSdoPointType) obj;

        try
        {
            return
                OracleSdoHelper.objectsEqual(getX(), otherObject.getX()) &&
                OracleSdoHelper.objectsEqual(getY(), otherObject.getY()) &&
                OracleSdoHelper.objectsEqual(getZ(), otherObject.getZ());
        }
        catch (SQLException ex)
        {
            return false;
        }
    }

    public int hashCode()
    {
        try
        {
            int hash = 7;
            Object o;
            o = getX();
            hash = 31 * hash + (null == o ? 0 : o.hashCode());
            o = getY();
            hash = 31 * hash + (null == o ? 0 : o.hashCode());
            o = getZ();
            hash = 31 * hash + (null == o ? 0 : o.hashCode());
            return hash;
        }
        catch (SQLException ex)
        {
            return 0;
        }
    }
}
