/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.util.CellRangeAddress8Bit;
import org.apache.poi.util.LittleEndian;

public abstract class SharedValueRecordBase
extends Record {
    private CellRangeAddress8Bit _range;

    protected SharedValueRecordBase(CellRangeAddress8Bit range) {
        this._range = range;
    }

    protected SharedValueRecordBase() {
        this(new CellRangeAddress8Bit(0, 0, 0, 0));
    }

    public SharedValueRecordBase(RecordInputStream in) {
        this._range = new CellRangeAddress8Bit(in);
    }

    public final CellRangeAddress8Bit getRange() {
        return this._range;
    }

    public final int getFirstRow() {
        return this._range.getFirstRow();
    }

    public final int getLastRow() {
        return this._range.getLastRow();
    }

    public final int getFirstColumn() {
        return (short)this._range.getFirstColumn();
    }

    public final int getLastColumn() {
        return (short)this._range.getLastColumn();
    }

    public final int getRecordSize() {
        return 10 + this.getExtraDataSize();
    }

    protected abstract int getExtraDataSize();

    protected abstract void serializeExtraData(int var1, byte[] var2);

    public final int serialize(int offset, byte[] data) {
        int dataSize = 6 + this.getExtraDataSize();
        LittleEndian.putShort(data, 0 + offset, this.getSid());
        LittleEndian.putUShort(data, 2 + offset, dataSize);
        int pos = offset + 4;
        this._range.serialize(pos, data);
        this.serializeExtraData(pos += 6, data);
        return dataSize + 4;
    }

    public final boolean isInRange(int rowIx, int colIx) {
        CellRangeAddress8Bit r = this._range;
        return r.getFirstRow() <= rowIx && r.getLastRow() >= rowIx && r.getFirstColumn() <= colIx && r.getLastColumn() >= colIx;
    }

    public final boolean isFirstCell(int rowIx, int colIx) {
        CellRangeAddress8Bit r = this.getRange();
        return r.getFirstRow() == rowIx && r.getFirstColumn() == colIx;
    }
}

