/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.util.CellRangeAddressBase;
import org.apache.poi.util.LittleEndian;

public final class CellRangeAddress8Bit
extends CellRangeAddressBase {
    public static final int ENCODED_SIZE = 6;

    public CellRangeAddress8Bit(int firstRow, int lastRow, int firstCol, int lastCol) {
        super(firstRow, lastRow, firstCol, lastCol);
    }

    public CellRangeAddress8Bit(RecordInputStream in) {
        super(CellRangeAddress8Bit.readUShortAndCheck(in), in.readUShort(), in.readUByte(), in.readUByte());
    }

    private static int readUShortAndCheck(RecordInputStream in) {
        if (in.remaining() < 6) {
            throw new RuntimeException("Ran out of data reading CellRangeAddress");
        }
        return in.readUShort();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putUShort(data, offset + 0, this.getFirstRow());
        LittleEndian.putUShort(data, offset + 2, this.getLastRow());
        LittleEndian.putByte(data, offset + 4, this.getFirstColumn());
        LittleEndian.putByte(data, offset + 5, this.getLastColumn());
        return 6;
    }

    public CellRangeAddress8Bit copy() {
        return new CellRangeAddress8Bit(this.getFirstRow(), this.getLastRow(), this.getFirstColumn(), this.getLastColumn());
    }

    public static int getEncodedSize(int numberOfItems) {
        return numberOfItems * 6;
    }
}

