/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.db2;

import java.util.Arrays;
import java.util.Collection;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.dataset.datatype.StringDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2DataTypeFactory
extends DefaultDataTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger((Class)Db2DataTypeFactory.class);
    private static final Collection DATABASE_PRODUCTS = Arrays.asList("db2");
    static final DataType DB2XML_XMLVARCHAR = new StringDataType("DB2XML.XMLVARCHAR", 2001);
    static final DataType DB2XML_XMLCLOB = new StringDataType("DB2XML.XMLCLOB", 2001);
    static final DataType DB2XML_XMLFILE = new StringDataType("DB2XML.XMLFILE", 2001);

    public Collection getValidDbProducts() {
        return DATABASE_PRODUCTS;
    }

    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        if (logger.isDebugEnabled()) {
            logger.debug("createDataType(sqlType={}, sqlTypeName={}) - start", (Object)String.valueOf(sqlType), (Object)sqlTypeName);
        }
        if (sqlType == 2001) {
            if (sqlTypeName.equals(DB2XML_XMLVARCHAR.toString())) {
                return DB2XML_XMLVARCHAR;
            }
            if (sqlTypeName.equals(DB2XML_XMLCLOB.toString())) {
                return DB2XML_XMLCLOB;
            }
            if (sqlTypeName.equals(DB2XML_XMLFILE.toString())) {
                return DB2XML_XMLFILE;
            }
        }
        return super.createDataType(sqlType, sqlTypeName);
    }
}

