import java.sql.*;
import java.util.ArrayList;
import java.util.HashMap;

/**
* caɃANZX邽߂̃NX
*/
public class DBAccessor implements Cloneable {
  /** G[ǂɂo͂Ȃ */
  final public static int TO_NO = 0;
  /** G[R\[ɏo͂ */
  final public static int TO_CONSOLE = 1;
  /** G[Loggďo͂ */
  final public static int TO_LOG = 2;
  /** G[Dialogɏo͂ */
  final public static int TO_DIALOG = 3;
  
  /** f[^ǂݍރ[h */
  public static enum MODE {
    ALL, //Sf[^ǂݍ
    ONE  //PR[hǂݍ
  }
  
  /** G[ɃȌo͐ */
  protected int errorLog = TO_CONSOLE;
  
  /**  f[^x[XRlNV */
  protected Connection con = null;
  /**  ڑ(URL) */
  protected String connectionString = null;
  /**  hCo */
  protected String driverName = null;
  /**  pX[h */
  protected String pass = null;
  
  private static DBAccessor self = null;
  /**  [U */
  protected String user = null;
  
  
  /**
  * RXgN^B
  *
  *@param  driverName        DBhCo
  *@param  connectionString  DBڑiURLj
  *@param  user              [U[
  *@param  pass              pX[h
  */
  public DBAccessor(String driverName, String connectionString, String user, String pass) {
    this(driverName, connectionString, user, pass, TO_CONSOLE);
  }
  
  /**
  * RXgN^B
  *
  *@param  driverName        DBhCo
  *@param  connectionString  DBڑiURLj
  *@param  user              [U[
  *@param  pass              pX[h
  *@param  errorLog          G[̏o͐BTO_NOATO_CONSOLEATO_LOGATO_DIALOĜꂩ
  */
  public DBAccessor(String driverName, String connectionString, String user, String pass, int errorLog) {
    this.errorLog = errorLog;
    this.driverName = driverName;
    this.connectionString = connectionString;
    this.user = user;
    this.pass = pass;
    
    try {
      Class.forName(driverName);
    } catch (Exception e) {
      this.outputException(e);
    }
  }
  
  
  @Override
  public Object clone(){
    return new DBAccessor(
      this.driverName,
      this.connectionString,
      this.user,
      this.pass,
      this.errorLog);
  }

  
  
  /**  ڑ */
  public void close() {
    if (!isClosed()) {
      try {
        con.close();
      } catch (Exception e) {
        this.outputException(e);
      }
      con = null;
    }
  }
  
  /**
  * f[^x[XɐڑASQL f[^x[Xɑ邽߂ Statement IuWFNg𐶐܂B
  *
  *@return    VftHg Statement IuWFNg
  *@exception  SQLException  f[^x[XANZXG[ꍇÃ\bhN[Yꂽڑɑ΂ČĂяoꂽꍇA܂͎w肳ꂽp[^^ѕs ResultSet 萔łȂꍇ 
  */
  public Statement createStatement() throws SQLException{
    if (connect()){
      return con.createStatement();
    }
    return null;
  }
  
  /**
  * f[^x[XɐڑAp[^t SQL f[^x[Xɑ邽߂ PreparedStatement IuWFNg𐶐܂B  
  *
  *@param  sql  1 ȏ '?' IN p[^v[Xz_[܂߂邱Ƃł SQL  
  *@return    vRpCꂽ SQL ܂ސVftHg PreparedStatement IuWFNg 
  *@exception  SQLException  f[^x[XANZXG[ꍇA܂͂̃\bhN[YꂽڑɂČĂяoꂽꍇ 
  */
  public PreparedStatement prepareStatement(String sql) throws SQLException {
    if (connect()){
      return con.prepareStatement(sql);
    }
    return null;
  }
  
  /**
  * f[^x[X̃XgAhvV[W[Ăяo߂ CallableStatement IuWFNg𐶐܂
  *
  *@param  sql - 1 ȏ '?' p[^v[Xz_[܂߂邱Ƃł SQL B ʏ킱́̕AJBDC ĂяõGXP[v\gpĎw肳
  *@return    vRpCꂽ SQL ܂ސVftHg CallableStatement IuWFNg
  *@exception  SQLException  f[^x[XANZXG[ꍇA܂͂̃\bhN[YꂽڑɂČĂяoꂽꍇ 
  */
  public CallableStatement prepareCall(String sql) throws SQLException {
    if (connect()){
      return con.prepareCall(sql);
    }
    return null;
  }
  
  /**
  * w肳ꂽ StatmentNX CX^X܂B  
  *
  *@param  st  StatmentNX CX^X
  */
  public void close(Statement st){
    if (st != null){
      try {
        st.close();
      } catch (Exception e){
        this.outputException(e);
      }
    }
  }
  
  /**
  * w肳ꂽ ResultSetNX CX^X܂B  
  *
  *@param  rs  ResultSetNX CX^X
  */
  public void close(ResultSet rs){
    if (rs != null){
      try {
        rs.close();
      } catch (Exception e){
        this.outputException(e);
      }
    }
  }
  
  /**
  * w肳ꂽ StatmentNX CX^X  ResultSetNX CX^X ܂B  
  *
  *@param  st  StatmentNX CX^X
  *@param  rs  ResultSetNX CX^X
  */
  public void close(Statement st, ResultSet rs){
    close(rs);
    close(st);
  }
  
  /**
  * R~bg
  *
  *@return    R~bgɐꍇTrueAȊOFalseB
  */
  public boolean commit() {
    if (isClosed()) {
      return false;
    }
    
    try {
      con.commit();
      return true;
    } catch (Exception e) {
      this.outputException(e);
      return false;
    }
  }
  
  
  
  /**
  *  f[^x[Xڑ
  *
  *@return    ڑɐꍇTrueAȊOFalseB
  */
  public boolean connect() throws SQLException{
    boolean result = false;
    if (isClosed()) {
      con = DriverManager.getConnection(connectionString,
        user, pass);
      con.setAutoCommit(false);
      result = true;
    } else {
      // Log.getLogger().severe("ɐڑĂ܂");
      result = true;
    }
    return result;
  }
  
  
  /**
  *  w肳ꂽp[^DBAccessorCX^XԂB
  *  getInstance() gp邱ƂɂAꂽ
  *  CX^XoƂoB<br><br>
  *  AȑOɐꂽCX^XΐڑB
  *
  *@param  driverName        DBhCo
  *@param  connectionString  DBڑiURLj
  *@param  user              [U[
  *@param  pass              pX[h
  *@return                   DBAccessor̃CX^X
  */
  public static DBAccessor createInstance(String driverName, String connectionString, String user, String pass) {
    return createInstance(driverName, connectionString, user, pass, TO_CONSOLE);
  }
  
  /**
  *  w肳ꂽp[^DBAccessorCX^XԂB
  *  getInstance() gp邱ƂɂAꂽ
  *  CX^XoƂoB<br><br>
  *  AȑOɐꂽCX^XΐڑB
  *
  *@param  driverName        DBhCo
  *@param  connectionString  DBڑiURLj
  *@param  user              [U[
  *@param  pass              pX[h
  *@param  errorLog          G[̏o͐BTO_NOATO_CONSOLEATO_LOGATO_DIALOĜꂩ
  *@return                   DBAccessor̃CX^X
  */
  public static DBAccessor createInstance(String driverName, String connectionString, String user, String pass, int errorLog) {
    if (self != null && !self.isClosed()){
      self.close();
    }
    self = new DBAccessor(driverName, connectionString, user, pass, errorLog);
    return getInstance();
  }
  
  
  
  /**
  *  createInstance()\bhɂĐꂽCX^X
  *  擾B
  *
  *@return    createInstanceɂĐꂽDBAccessorCX^X
  */
  public static DBAccessor getInstance() {
    return self;
  }
  
  
  /**
  *  createInstance()\bhɂĐꂽCX^X
  *  VDBAccessorԂ
  *
  *@return    createInstanceɂĐꂽDBAccessorCX^X
  *           ꂽVDBAccessor
  */
  public static DBAccessor newInstance() {
    return (DBAccessor)getInstance().clone();
  }
  
  
  /**
  *  ڑԂԂB
  *
  *@return    ĂꍇTrueB
  */
  public boolean isClosed() {
    try {
      return (con == null || con.isClosed());
    } catch (Exception e) {
      this.outputException(e);
      return true;
    }
    
  }
  
  
  /**
  * [obN
  *
  *@return    Description of the Return Value
  */
  public boolean rollback() {
    if (isClosed()) {
      return false;
    }
    
    try {
      con.rollback();
      return true;
    } catch (Exception e) {
      this.outputException(e);
      return false;
    }
  }
  
  /**
  * w肳ꂽ ExceptionNX CX^XG[o͂܂B
  *
  *@param  e  ExceptionNX CX^X
  */
  private void outputException(Exception e){
    switch (errorLog) {
    case TO_LOG:
      //Log.logStackTrace(e);
      break;
    case TO_CONSOLE:
      System.out.println(e);
      break;
    case TO_NO:
      break;
    case TO_DIALOG:
      javax.swing.JOptionPane.showMessageDialog(null, e);
      break;
    }
  }
  
  /**
  * w肳ꂽG[̏o͐Zbg܂B
  *
  *@param  errorLog  G[̏o͐BTO_NOATO_CONSOLEATO_LOGATO_DIALOĜꂩ
  */
  public void setErrorLog(int errorLog){
    this.errorLog = errorLog;
  }
  
  /**
  * f[^x[X̃RlNVԂ܂B 
  * 
  *@return    f[^x[XRlNV
  */
  public Connection getConnection() throws SQLException{
    if (connect()){
      return con;
    }
    return null;
  }
  
  /**
  * p[^̌^ɍ킹 PreparedStatement Ƀp[^ZbgB
  * 
  *@param  st             PreparedStatementCX^X
  *@param  param          p[^ArrayList
  *@exception  Exception  ɔO
  */
  public void setParameters(PreparedStatement st, ArrayList<Object> param) throws Exception {
    setParameters(st, param.toArray());
  }
  
  /**
  * p[^̌^ɍ킹 PreparedStatement Ƀp[^ZbgB
  * 
  *@param  st             PreparedStatementCX^X
  *@param  param          p[^Objectz
  *@exception  Exception  ɔO
  */
  public void setParameters(PreparedStatement st, Object[] param) throws Exception {
    for (int i = 0; i < param.length; i++) {
      if (param[i] instanceof Long){
        st.setLong(i + 1, (Long)param[i]);
      } else if (param[i] instanceof Double){
        st.setDouble(i + 1, (Double)param[i]);
      } else if (param[i] instanceof Integer){
        st.setInt(i + 1, (Integer)param[i]);
      } else if (param[i] instanceof java.sql.Date){
        st.setDate(i + 1, (java.sql.Date)param[i]);
      } else {
        st.setString(i + 1, (String)param[i]);
      }
    }
  }
  
  /** 
  * w肳ꂽSQLsAsʂ ArrayList ŕԂB
  * 
  * @param sql s SQL
  * @param mode ߂l̃[hBALL ̏ꍇ͑SAONE ̏ꍇ͍ŏ̂PԂB
  */
  public ArrayList<HashMap> executeQuery(String sql, MODE mode) throws Exception {
    if (!connect()){
      return null;
    }
    
    PreparedStatement st = con.prepareStatement(sql);
    ArrayList<Object> args = new ArrayList<Object>();
    return executeQuery(st,args, mode);
  }
  
  /** 
  * w肳ꂽ PreparedStatement sAsʂ ArrayList ŕԂB
  * 
  * @param st s PreparedStatement
  * @param args PreparedStatement ̈BKvȂꍇ nullB 
  * @param mode ߂l̃[hBALL ̏ꍇ͑SAONE ̏ꍇ͍ŏ̂PԂB
  */
  public ArrayList<HashMap> executeQuery(PreparedStatement st, ArrayList<Object> args, MODE mode) throws Exception {
    ResultSet rs = null;
    ArrayList<HashMap> rows = null;
    
    try {
      if (args == null){
        args = new ArrayList<Object>();
      }
      
      
      ResultSetMetaData rsmd = null;
      setParameters(st,args);
      
      rs = st.executeQuery();
      rsmd = rs.getMetaData();
      
      int colCnt = rsmd.getColumnCount();
      String colLabel = "";
      rows = new ArrayList<HashMap>();
      while(rs.next()){
        HashMap<Object,Object> row = new HashMap<Object,Object>();
        for (int i = 0; i < colCnt; i++){
          colLabel = rsmd.getColumnLabel(i+1);
          row.put(colLabel,rs.getObject(colLabel));
        }
        rows.add(row);
        
        if (mode == MODE.ONE){
          break;
        }
      }
      return rows;
    } finally {
      close(st,rs);
    }
  }
}

