/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.AbstractTableMetaData;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowerCaseTableMetaData
extends AbstractTableMetaData {
    private static final Logger logger = LoggerFactory.getLogger((Class)LowerCaseTableMetaData.class);
    private final String _tableName;
    private final Column[] _columns;
    private final Column[] _primaryKeys;

    public LowerCaseTableMetaData(String tableName, Column[] columns) {
        this(tableName, columns, new Column[0]);
    }

    public LowerCaseTableMetaData(String tableName, Column[] columns, String[] primaryKeys) {
        this(tableName, columns, Columns.getColumns(primaryKeys, columns));
    }

    public LowerCaseTableMetaData(ITableMetaData metaData) throws DataSetException {
        this(metaData.getTableName(), metaData.getColumns(), metaData.getPrimaryKeys());
    }

    public LowerCaseTableMetaData(String tableName, Column[] columns, Column[] primaryKeys) {
        this._tableName = tableName.toLowerCase();
        this._columns = this.createLowerColumns(columns);
        this._primaryKeys = this.createLowerColumns(primaryKeys);
    }

    private Column[] createLowerColumns(Column[] columns) {
        logger.debug("createLowerColumns(columns={}) - start", (Object[])columns);
        Column[] lowerColumns = new Column[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            lowerColumns[i] = this.createLowerColumn(columns[i]);
        }
        return lowerColumns;
    }

    private Column createLowerColumn(Column column) {
        logger.debug("createLowerColumn(column={}) - start", (Object)column);
        return new Column(column.getColumnName().toLowerCase(), column.getDataType(), column.getSqlTypeName(), column.getNullable(), column.getDefaultValue());
    }

    public String getTableName() {
        return this._tableName;
    }

    public Column[] getColumns() {
        return this._columns;
    }

    public Column[] getPrimaryKeys() {
        return this._primaryKeys;
    }
}

