/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.util.Arrays;

public class VerifyTableDefinition {
    private final String tableName;
    private final String[] columnExclusionFilters;
    private final String[] columnInclusionFilters;

    public VerifyTableDefinition(String table, String[] excludeColumns) {
        this(table, excludeColumns, null);
    }

    public VerifyTableDefinition(String table, String[] excludeColumns, String[] includeColumns) {
        if (table == null) {
            throw new IllegalArgumentException("table is null.");
        }
        this.tableName = table;
        this.columnExclusionFilters = excludeColumns;
        this.columnInclusionFilters = includeColumns;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String[] getColumnExclusionFilters() {
        return this.columnExclusionFilters;
    }

    public String[] getColumnInclusionFilters() {
        return this.columnInclusionFilters;
    }

    public String toString() {
        String exclusionString = this.arrayToString(this.columnExclusionFilters);
        String inclusionString = this.arrayToString(this.columnInclusionFilters);
        StringBuilder sb = new StringBuilder(1000);
        sb.append("tableName='").append(this.tableName).append("'");
        sb.append(", columnExclusionFilters='").append(exclusionString).append("'");
        sb.append(", columnInclusionFilters='").append(inclusionString).append("'");
        return sb.toString();
    }

    protected String arrayToString(String[] array) {
        String string = array == null ? "" : Arrays.toString(array);
        return string;
    }
}

