/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.mssql;

import java.util.Arrays;
import java.util.Collection;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsSqlDataTypeFactory
extends DefaultDataTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger((Class)MsSqlDataTypeFactory.class);
    private static final Collection DATABASE_PRODUCTS = Arrays.asList("mssql", "Microsoft SQL Server");
    public static final int NCHAR = -8;
    public static final int NVARCHAR = -9;
    public static final int NTEXT = -10;
    public static final int NTEXT_MSSQL_2005 = -16;

    public Collection getValidDbProducts() {
        return DATABASE_PRODUCTS;
    }

    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        if (logger.isDebugEnabled()) {
            logger.debug("createDataType(sqlType={}, sqlTypeName={}) - start", (Object)String.valueOf(sqlType), (Object)sqlTypeName);
        }
        switch (sqlType) {
            case -8: {
                return DataType.CHAR;
            }
            case -9: {
                return DataType.VARCHAR;
            }
            case -10: {
                return DataType.LONGVARCHAR;
            }
            case -16: {
                return DataType.LONGVARCHAR;
            }
        }
        return super.createDataType(sqlType, sqlTypeName);
    }
}

