import Link from 'next/link';
import axios from "axios";
import React, { Component } from 'react'

const axiosApi = axios.create({
    baseURL: 'http://localhost:3000', // バックエンドB のURL:port を指定する
    headers: {
      'Content-Type': 'application/json',
      'X-Requested-With': 'XMLHttpRequest'
    },
    responseType: 'json'
});

class Index extends Component {
  static async getInitialProps({ req }) {
    // const userAgent = req ? req.headers['user-agent'] : navigator.userAgent
    // return { userAgent }
    return {
      isServer: typeof window === 'undefined'
    }
  }
  
  constructor(props) {
    super(props);
    this.validate_token = this.validate_token.bind(this);
    this.sign_in = this.sign_in.bind(this);
    this.sign_up = this.sign_up.bind(this);
    this.post = this.post.bind(this);
    this.state = {
      token: "",
      uid: "",
      client: ""
    }
  }
  
  
  // const getProfile = () => {
  //   //ここでGETメソッドを使用してgithubのプロフィールを取得します。
  //   axios.get("http://localhost:3000/posts")
  //   .then(function(response) {
  //       console.log("ok")
  //       console.log(response)
  //   })
  //   .catch(function(error) {
  //       console.log("ng")
  //       console.log(error)
  //   })
  // }
  
  // const getPosts = () => {
  //   axiosApi.get('/posts')
  //   // axios.get('/posts')
  //   .then(function(response) {
  //       console.log(response)
  //   })
  //   .catch(function(error) {
  //       console.log(error)
  //       console.log('ERROR!! occurred in Backend.')
  //   });
  // };
  
  // const getProfile = () => {
  //   //ここでGETメソッドを使用してgithubのプロフィールを取得します。
  //   axios.get("http://localhost:3000/posts")
  //   .then(function(response) {
  //       console.log("ok")
  //       console.log(response)
  //   })
  //   .catch(function(error) {
  //       console.log("ng")
  //       console.log(error)
  //   })
  // }
  
  sign_up() {
    axios.post("http://localhost:3000/auth", {email: "hoge@aaa.bb.cc", password:"password"})
    // axios.get("http://localhost:3000/posts")
    .then(function(response) {
        console.log(response)
    })
    .catch(function(error) {
        console.log(error)
    })
  }
  
  sign_in() {
    axios.post("http://localhost:3000/auth/sign_in", {email: "hoge@aaa.bb.cc", password:"password"})
    // axiosApi.post("http://localhost:3000/auth/sign_in", {email: "hoge@aaa.bb.cc", password:"password"})
    .then(function(response) {
        console.log(response)
        this.setState({token: response.headers["access-token"]})
        this.setState({uid: response.headers["uid"]})
        this.setState({client: response.headers["client"]})
        console.log(this.state)
    }.bind(this))
    .catch(function(error) {
        console.log(error)
    })
  }
  
  validate_token() {
    axios.get("http://localhost:3000/auth/validate_token",
      { headers: {
        "access-token": this.state.token,
        "uid": this.state.uid,
        "client": this.state.client,
      }})
    // axiosApi.post("http://localhost:3000/auth/sign_in", {email: "hoge@aaa.bb.cc", password:"password"})
    .then(function(response) {
        console.log(response)
    })
    .catch(function(error) {
        console.log(error)
    })
  }
  
  post() {
    axios.get("http://localhost:3000/posts",
      { headers: {
        "access-token": this.state.token,
        "uid": this.state.uid,
        "client": this.state.client,
      }})
    // axios.get("http://localhost:3000/posts")
    .then(function(response) {
        console.log(response)
    })
    .catch(function(error) {
        console.log(error)
    })
  }
  
  
  render() {
    return  (
      <div>
      <h1>Index page.</h1>
      <p>This page was rendered on the server side: {this.props.isServer.toString()}</p>
      <Link href="/about">
      <a>About</a>
      </Link>
      <button onClick={this.sign_up}>sign_up</button>
      <button onClick={this.sign_in}>sign_in</button>
      <button onClick={this.validate_token}>validate_token</button>
      <button onClick={this.post}>post</button>
      </div>
      ); 
  }
}

export default Index;
