package com.example.demo.controller;

import java.util.List;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
//import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.model.Weather;
import com.example.demo.service.WeatherService;


@Controller
// @RestController
// @RequestMapping("test")
public class HelloSpringBootWebController {
  @Autowired
  WeatherService weatherService;
  
  @GetMapping("/")
  public String index(Model model) {
    model.addAttribute("message", "Hello Springboot index");
    // 気象データの取得
    List<Weather> weatherDataList = weatherService.findAllWeatherData();
    model.addAttribute("weatherDataList", weatherDataList);
    
    return "index";
  }
  
  @GetMapping("/new")
  public String newData(Model model) {
    return "new";
  }
  
  @RequestMapping("/create")
  public String create(@ModelAttribute Weather weather) {
    // return "redirect:/";
    // System.out.println(weather); 
    Weather createWeather = weatherService.save(weather);
    return "redirect:/edit/" + createWeather.getId();
  }
  
  @RequestMapping("/edit/{id}")
  public String edit(@PathVariable Integer id, Model model) {
    Weather weather = weatherService.findWeatherData(id).get();
    model.addAttribute("weather", weather);
    
    return "edit";
  }
  
  @RequestMapping("/update/{id}")
  public String create(@PathVariable Integer id, @ModelAttribute Weather weather) {
    weather.setId(id); 
    Weather createWeather = weatherService.save(weather);
    return "redirect:/edit/" + createWeather.getId();
  }
  
  @GetMapping("/show/{id}")
  public String show(@PathVariable Integer id, Model model) {
    model.addAttribute("message", "Hello Springboot hoge");
    Weather weather = weatherService.findWeatherData(id).get();
    model.addAttribute("weather", weather);
    return "show";
  }
  
  @GetMapping("/hoge")
  public String hoge(Model model) {
    model.addAttribute("message", "Hello Springboot hoge");
    System.out.println("hoge");
    return "index";
  }
  
  // @RequestMapping(method = RequestMethod.GET)
  // public List<Weather> list() {
  //   return weatherService.findAllWeatherData();
  // }
  
}
