package com.example.demo.service;
import java.util.List;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.example.demo.model.Weather;
import com.example.demo.repository.WeatherRepository;
@Service
@Transactional
public class WeatherService{
  
  @Autowired
  WeatherRepository weatherRepository;
  
  /**
   * レコードを全件取得する。
   * @return
   */
  public List<Weather> findAllWeatherData(){
    return weatherRepository.findAll();
  }
  
  public Optional<Weather> findWeatherData(Integer id) {
    return weatherRepository.findById(id);
  }
  
  public Weather save(Weather weather) {
    return weatherRepository.save(weather);
  }
  
  public Weather save2(Weather weather) {
    return weatherRepository.save(weather);
  }
}