/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2x;

import SQLite.JDBC2x.JDBCResultSetMetaData;
import SQLite.JDBC2x.JDBCStatement;
import SQLite.JDBC2x.TableResultX;
import SQLite.StringEncoder;
import SQLite.TableResult;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class JDBCResultSet
implements ResultSet {
    private int row;
    protected TableResult tr;
    private JDBCStatement s;
    private JDBCResultSetMetaData m;
    private String lastg;

    public JDBCResultSet(TableResult tableResult, JDBCStatement jDBCStatement) {
        this.tr = tableResult;
        this.s = jDBCStatement;
        this.m = null;
        this.lastg = null;
        this.row = -1;
    }

    public boolean next() throws SQLException {
        if (this.tr == null) {
            return false;
        }
        ++this.row;
        return this.row < this.tr.nrows;
    }

    public int findColumn(String string) throws SQLException {
        JDBCResultSetMetaData jDBCResultSetMetaData = (JDBCResultSetMetaData)this.getMetaData();
        return jDBCResultSetMetaData.findColByName(string);
    }

    public int getRow() throws SQLException {
        if (this.tr == null) {
            throw new SQLException("not rows");
        }
        return this.row + 1;
    }

    public boolean previous() throws SQLException {
        if (this.tr == null) {
            return false;
        }
        if (this.row >= 0) {
            --this.row;
        }
        return this.row >= 0;
    }

    public boolean absolute(int n) throws SQLException {
        if (this.tr == null) {
            return false;
        }
        if (n < 0) {
            n = this.tr.nrows + 1 + n;
        }
        if (--n < 0 || n > this.tr.nrows) {
            return false;
        }
        this.row = n;
        return true;
    }

    public boolean relative(int n) throws SQLException {
        if (this.tr == null) {
            return false;
        }
        if (this.row + n < 0 || this.row + n >= this.tr.nrows) {
            return false;
        }
        this.row += n;
        return true;
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public int getFetchDirection() throws SQLException {
        throw new SQLException("not supported");
    }

    public void setFetchSize(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public int getFetchSize() throws SQLException {
        throw new SQLException("not supported");
    }

    public String getString(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        return this.lastg;
    }

    public String getString(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getString(n);
    }

    public int getInt(int n) throws SQLException {
        Integer n2 = this.internalGetInt(n);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    private Integer internalGetInt(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Integer.valueOf(this.lastg);
        }
        catch (Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public int getInt(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInt(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean getBoolean(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.m == null) {
            this.m = new JDBCResultSetMetaData(this);
        }
        return this.m;
    }

    public short getShort(int n) throws SQLException {
        Short s = this.internalGetShort(n);
        if (s != null) {
            return s;
        }
        return 0;
    }

    private Short internalGetShort(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Short.valueOf(this.lastg);
        }
        catch (Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public short getShort(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getShort(n);
    }

    public Time getTime(int n) throws SQLException {
        return this.internalGetTime(n, null);
    }

    private Time internalGetTime(int n, Calendar calendar) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Time.valueOf(this.lastg);
        }
        catch (Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public Time getTime(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.internalGetTime(n, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n, calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.internalGetTimestamp(n, null);
    }

    private Timestamp internalGetTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Timestamp.valueOf(this.lastg);
        }
        catch (Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.internalGetTimestamp(n, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n, calendar);
    }

    public Date getDate(int n) throws SQLException {
        return this.internalGetDate(n, null);
    }

    private Date internalGetDate(int n, Calendar calendar) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Date.valueOf(this.lastg);
        }
        catch (Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public Date getDate(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.internalGetDate(n, calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n, calendar);
    }

    public double getDouble(int n) throws SQLException {
        Double d = this.internalGetDouble(n);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private Double internalGetDouble(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Double.valueOf(this.lastg);
        }
        catch (Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public double getDouble(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDouble(n);
    }

    public float getFloat(int n) throws SQLException {
        Float f = this.internalGetFloat(n);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    private Float internalGetFloat(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Float.valueOf(this.lastg);
        }
        catch (Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public float getFloat(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getFloat(n);
    }

    public long getLong(int n) throws SQLException {
        Long l = this.internalGetLong(n);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    private Long internalGetLong(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Long.valueOf(this.lastg);
        }
        catch (Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    public long getLong(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getLong(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte getByte(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte getByte(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        byte[] byArray = null;
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        if (this.lastg != null) {
            byArray = StringEncoder.decode(this.lastg);
        }
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBytes(n);
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public Object getObject(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        Object object = this.lastg;
        if (this.tr instanceof TableResultX) {
            switch (((TableResultX)this.tr).sql_type[n - 1]) {
                case 5: {
                    object = this.internalGetShort(n);
                    break;
                }
                case 4: {
                    object = this.internalGetInt(n);
                    break;
                }
                case 8: {
                    object = this.internalGetDouble(n);
                    break;
                }
                case 6: {
                    object = this.internalGetFloat(n);
                    break;
                }
                case -5: {
                    object = this.internalGetLong(n);
                }
            }
        }
        return object;
    }

    public Object getObject(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("not supported");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean wasNull() throws SQLException {
        return this.lastg == null;
    }

    public void clearWarnings() throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean isFirst() throws SQLException {
        if (this.tr == null) {
            return true;
        }
        return this.row == 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        return this.row < 0;
    }

    public void beforeFirst() throws SQLException {
        if (this.tr == null) {
            return;
        }
        this.row = -1;
    }

    public boolean first() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        this.row = 0;
        return true;
    }

    public boolean isAfterLast() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        return this.row >= this.tr.nrows;
    }

    public void afterLast() throws SQLException {
        if (this.tr == null) {
            return;
        }
        this.row = this.tr.nrows;
    }

    public boolean isLast() throws SQLException {
        if (this.tr == null) {
            return true;
        }
        return this.row == this.tr.nrows - 1;
    }

    public boolean last() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        this.row = this.tr.nrows - 1;
        return true;
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException("not supported");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("not supported");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("not supported");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("not supported");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("not supported");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("not supported");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateNull(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateString(int n, String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateNull(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Statement getStatement() throws SQLException {
        if (this.s == null) {
            throw new SQLException("stale result set");
        }
        return this.s;
    }

    public void close() throws SQLException {
        this.s = null;
        this.tr = null;
        this.lastg = null;
        this.row = -1;
    }

    public URL getURL(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        URL uRL = null;
        if (this.lastg == null) {
            return uRL;
        }
        try {
            uRL = new URL(this.lastg);
        }
        catch (Exception exception) {
            uRL = null;
        }
        return uRL;
    }

    public URL getURL(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getURL(n);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("not supported");
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException("not supported");
    }
}

