VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Document"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'*
'*      Copyright (c) 2000, 2001 Mihayl Stamenov <michael.stamenov@web.de>
'*
'* This program is free software; you can redistribute it and/or modify
'* it under the terms of the GNU General Public License as published by
'* the Free Software Foundation; either version 2, or (at your option)
'* any later version.
'*
'* This program is distributed in the hope that it will be useful,
'* but WITHOUT ANY WARRANTY; without even the implied warranty of
'* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'* GNU General Public License for more details.
'*
'* You should have received a copy of the GNU General Public License
'* along with this program; see the file COPYING.  If not, write to
'* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
'*

'===============================================================================
' Name: Document
' Purpose: Represents the top level of the XML source. Includes methods and
'   properties used to obtain or create all other XML objects.
' Remarks: Does not implement all properties, methods and events of the
'   corresponding MSXML class IXMLDOMDocument.
'   <p>Only this object can be created. All other objects are accessed or
'   created from the document.
' Functions:
' Properties:
' Methods:
' Started: 30.02.2001
' Modified: 30.02.2001
'===============================================================================
Option Explicit

'===============================================================================
' Name: Get documentElement
' Input:
'   None
' Output:
'   Element - DOMElement object that represents the single element representing
' the root of the XML document tree. Returns Nothing if no root exists.
' Purpose: Returns the root element of the document.
' Remarks: None
'===============================================================================
Public Property Get documentElement() As Element
End Property

'===============================================================================
' Name: Function load
' Input:
'   ByVal xmlSource As String - Indicator of the object that specifies
' the source for the XML document.
' Output:
'   Boolean - True if the load succeeded; False if the load failed.
' Purpose: Loads an XML document from the specified location.
' Remarks: None
'===============================================================================
Public Function load(ByVal xmlSource As String) As Boolean
End Function

'===============================================================================
' Name: Sub save
' Input:
'   ByVal destination As String - Specifies the file name. Note that this must
' be a file name rather than a URL. The file is created if necessary and the
' contents are entirely replaced with the contents of the saved document.
' Output:
'   None
' Purpose: Saves an XML document to the specified location.
' Remarks: Not implemented.
'===============================================================================
Public Sub save(ByVal destination As String)
End Sub

'===============================================================================
' Name: Function nodeFromID
' Input:
'   ByVal idString As String - Value of the ID to match.
' Output:
'   Element - Node that matches the supplied ID. If no nodes match, this method
' returns Nothing.
' Purpose: Returns the node whose ID attribute matches the supplied value.
' Remarks: Only documentElement first level children can be selected.
'===============================================================================
Public Function nodeFromID(ByVal idString As String) As Element
End Function

'===============================================================================
' Name: Function createElement
' Input:
'   ByVal tagName As String - Name for the new element node. It is case
' sensitive. This name is subsequently available as the element node's nodeName
' property.
' Output:
'   Element - References to the new element or Nothing on failure.
' Purpose: Creates an element node using the specified name.
' Remarks: None
'===============================================================================
Public Function createElement(ByVal tagName As String) As Element
End Function

'===============================================================================
' Name: Function selectNodes
' Input:
'   ByVal queryString As String - XSL or XPath expression that is to be applied
' to the context defined by this node. Whether an XSL or XPath query is used is
' determined by the value of the SelectionLanguage property. By default,
' the expression is an XSL pattern query. The SelectionLanguage property can be
' set with the SetProperty method.
' Output:
'   NodeList - List of nodes selected by the XSL or XPath query. If no nodes
' are selected by the query, an empty node list is returned.
' Purpose: Applies the specified pattern-matching operation to this node's
'   context and returns the list of matching nodes.
' Remarks: SelectionLanguage and SetProperty properties are not implemented.
'===============================================================================
Public Function selectNodes(ByVal queryString As String) As NodeList
End Function

'===============================================================================
' Name: Function selectSingleNode
' Input:
'   ByVal queryString As String - String specifying the XSL or XPath query that
' is to be applied to the context defined by this node. Whether an XSL or XPath
' query is used is determined by the value of the SelectionLanguage property.
' By default, the expression is an XSL pattern query. The SelectionLanguage
' property can be set with the SetProperty method.
' Output:
'   Element - First node that is selected by the XPath query. If no nodes result
' from the query, it returns Nothing.
' Purpose: Applies the specified pattern to this node's context and returns
'   the first matching node.
' Remarks: Not implemented.
'   SelectionLanguage and SetProperty properties are not implemented.
'===============================================================================
Public Function selectSingleNode(ByVal queryString As String) As Element
End Function

'===============================================================================
' Name: Function internalGetElement
' Input:
'   ByVal id As String - Specifies the ID of the element.
'   ByVal isNew As Boolean - Specifies whether the element is new one.
'   ByVal strTag As String - Specifies the name of the element.
' Output:
'   Element - Element with specified ID.
' Purpose: Internal element allocation, initialization and caching routine.
' Remarks: Used internally for Element object caching.
'===============================================================================
Friend Function internalGetElement(ByVal id As String, _
    ByVal isNew As Boolean, ByVal strTag As String) As Element
End Function

'===============================================================================
' Name: Sub cacheAddElement
' Input:
'   ByVal id As String - Specifies the ID of the element.
'   ByRef objElement As Element - Specifies reference to element to update. If
' this is Nothing the element is removed form the cache.
' Output:
'   None
' Purpose: Internal element cache update routine.
' Remarks: Used internally for Element object caching update.
'===============================================================================
Friend Sub cacheAddElement(ByVal id As String, objElement As Element)
End Sub

' ==============================================================================

