VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Element"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'*
'*      Copyright (c) 2000, 2001 Mihayl Stamenov <michael.stamenov@web.de>
'*
'* This program is free software; you can redistribute it and/or modify
'* it under the terms of the GNU General Public License as published by
'* the Free Software Foundation; either version 2, or (at your option)
'* any later version.
'*
'* This program is distributed in the hope that it will be useful,
'* but WITHOUT ANY WARRANTY; without even the implied warranty of
'* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'* GNU General Public License for more details.
'*
'* You should have received a copy of the GNU General Public License
'* along with this program; see the file COPYING.  If not, write to
'* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
'*

'===============================================================================
' Name: Element
' Purpose: Represents the element object.
' Remarks: Does not implement all properties, methods and events of the
'   corresponding MSXML class IXMLDOMElement. Simulates IXMLDOMNode and
'   IXMLDOMAttribute nodes.
' Functions:
' Properties:
' Methods:
' Started: 30.02.2001
' Modified: 30.02.2001
'===============================================================================
Option Explicit

'===============================================================================
' Name: Sub setNew
' Input:
'   ByVal blnIsNew As Boolean - Specifies whether the object is new one.
' Output:
'   None
' Purpose: Sets the object as newly created object.
' Remarks: Used internally for flagging elements not appended to a existing
'   node. This flag is used for deciding whether to INSERT or UPDATE.
'===============================================================================
Friend Sub setNew(ByVal blnIsNew As Boolean)
End Sub

'===============================================================================
' Name: Sub setTag
' Input:
'   ByVal strTagName As String - Specifies the name of the element.
' Output:
'   None
' Purpose: Sets the name of the element.
' Remarks: Used internally for storing the name of the database table.
'===============================================================================
Friend Sub setTag(ByVal strTagName As String)
End Sub

'===============================================================================
' Name: Sub setDefAttribute
' Input:
'   ByVal strAttributeName As String - Specifies the name of the attribute
' returned as default.
' Output:
'   None
' Purpose: Sets the name of the attribute returned as element's text.
' Remarks: Used internally for storing the name of the attribute for Attribute
'   nodes emulation.
'   <p>Also emulates element text (text()). This means that there caan be only
'   one text node.
'===============================================================================
Friend Sub setDefAttribute(ByVal strAttributeName As String)
End Sub

'===============================================================================
' Name: Let id
' Input:
'   ByVal strId As String - Specifies the id of the element.
' Output:
'   None
' Purpose: Sets the id if the element.
' Remarks: The id is the primary key of the element in the database. The pair
'   id and tablename identyfy unique the element.
'===============================================================================
Friend Property Let id(ByVal strId As String)
End Property

'===============================================================================
' Name: Sub restore
' Input:
'   None
' Output:
'   None
' Purpose: Restores the state of the element previously backe up with backup.
' Remarks: Used for restoring the state after transaction rollback.
'===============================================================================
Friend Sub restore()
End Sub

'===============================================================================
' Name: Sub reload
' Input:
'   None
' Output:
'   None
' Purpose: Reloads the data from the database.
' Remarks: Used for updating the object data before reading or writing any data
'   to the database in the context of a transaction.
'===============================================================================
Friend Sub reload()
End Sub

'===============================================================================
' Name: Set ownerDocument
' Input:
'   ByRef doc As Document - Specifies reference to the document object.
' Output:
'   None
' Purpose: Sets the reference to the owner document object.
' Remarks: None
'===============================================================================
Friend Property Set ownerDocument(ByRef doc As Document)
End Property

'===============================================================================
' Name: Get ownerDocument
' Input:
'   None
' Output:
'   Document - Reference to the document object.
' Purpose: Returns reference to the owner document object.
' Remarks: None
'===============================================================================
Public Property Get ownerDocument() As Document
End Property

'===============================================================================
' Name: Get text
' Input:
'   None
' Output:
'   String - The text representation of the contents of the node.
' Purpose: Returns the string representing the text contents of this node.
' Remarks: None
'===============================================================================
Public Property Get text() As String
End Property

'===============================================================================
' Name: Let text
' Input:
'   ByVal strNewText As String - String representing the text content of this node.
' This value varies depending on the value of the nodeType.
' Output:
'   None
' Purpose: Sets the text contents of this node.
' Remarks: None
'===============================================================================
Public Property Let text(ByVal strNewText As String)
End Property

'===============================================================================
' Name: Get parentNode
' Input:
'   None
' Output:
'   Element - Parent of the given node instance. However, if a node has just
' been created and not yet added to the tree, or if it has been removed from
' the tree, the parent is Nothing.
' Purpose: Returns the parent node (for nodes that can have parents).
' Remarks: None
'===============================================================================
Public Property Get parentNode() As Element
End Property

'===============================================================================
' Name: Function appendChild
' Input:
'   ByVal newChild As Element - Reference to the new child node to be appended
' to the end of the list of children of this node.
' Output:
'   Element - New child node successfully appended to the list. If Nothing,
'   no object is created.
' Purpose: Appends newChild as the last child of this node.
' Remarks: Node order is not implemented.
'===============================================================================
Public Function appendChild(ByVal newChild As Element) As Element
End Function

'===============================================================================
' Name: Function removeChild
' Input:
'   ByVal childNode As Element - Child node to be removed from the list of
' children of this node.
' Output:
'   Element - Removed child node. If Nothing, no object is removed.
' Purpose: Removes the specified child node from the list of children and
'   returns it.
' Remarks: None
'===============================================================================
Public Function removeChild(ByVal childNode As Element) As Element
End Function

'===============================================================================
' Name: Function getAttribute
' Input:
'   ByVal name As String - Name of the attribute to return.
' Output:
'   String - String that contains the attribute value. The empty string is
' returned if the named attribute does not have a specified or default value.
' Purpose: Retrieves the value of the named attribute.
' Remarks: None
'===============================================================================
Public Function getAttribute(ByVal name As String) As String
End Function

'===============================================================================
' Name: Function setAttribute
' Input:
'   ByVal name As String - Name of the attribute to return.
'   ByVal value As String -  Name of the attribute. If an attribute with that
' name already exists, its value is changed.
' Output:
'   None
' Purpose: Sets the value of the named attribute.
' Remarks: If an attribute with that name does not exist, it is NOT created.
'===============================================================================
Public Sub setAttribute(ByVal name As String, ByVal value As String)
End Sub

'===============================================================================
' Name: Function selectNodes
' Input:
'   ByVal queryString As String - XSL or XPath expression that is to be applied
' to the context defined by this node. Whether an XSL or XPath query is used is
' determined by the value of the SelectionLanguage property. By default,
' the expression is an XSL pattern query. The SelectionLanguage property can be
' set with the SetProperty method.
' Output:
'   NodeList - List of nodes selected by the XSL or XPath query. If no nodes
' are selected by the query, an empty node list is returned.
' Purpose: Applies the specified pattern-matching operation to this node's
'   context and returns the list of matching nodes.
' Remarks: SelectionLanguage and SetProperty properties are not implemented.
'===============================================================================
Public Function selectNodes(ByVal queryString As String) As NodeList
End Function

'===============================================================================
' Name: Function selectSingleNode
' Input:
'   ByVal queryString As String - String specifying the XSL or XPath query that
' is to be applied to the context defined by this node. Whether an XSL or XPath
' query is used is determined by the value of the SelectionLanguage property.
' By default, the expression is an XSL pattern query. The SelectionLanguage
' property can be set with the SetProperty method.
' Output:
'   Element - First node that is selected by the XPath query. If no nodes result
' from the query, it returns Nothing.
' Purpose: Applies the specified pattern to this node's context and returns
'   the first matching node.
' Remarks: SelectionLanguage and SetProperty properties are not implemented.
'===============================================================================
Public Function selectSingleNode(ByVal queryString As String) As Element
End Function

'===============================================================================
' Name: Sub load
' Input:
'   None
' Output:
'   None
' Purpose: Loads the attribute names, values and types from the database.
' Remarks: None
'===============================================================================
Private Sub load()
End Sub

'===============================================================================
' Name: Sub insertElement
' Input:
'   None
' Output:
'   None
' Purpose: Inserts a new record in the database with the data from attribute
'   values collection.
' Remarks: None
'===============================================================================
Private Sub insertElement()
End Sub

'===============================================================================
' Name: Sub updateElement
' Input:
'   None
' Output:
'   None
' Purpose: Updates the data in the database with that in the object.
' Remarks: None
'===============================================================================
Private Sub updateElement()
End Sub

'===============================================================================
' Name: Sub deleteElement
' Input:
'   None
' Output:
'   None
' Purpose: Deletes the node from the database.
' Remarks: Not used
'===============================================================================
Private Sub deleteElement()
End Sub

'===============================================================================
' Name: Sub updateAttribute
' Input:
'   ByVal strName As String - Name of attribute to update.
' Output:
'   None
' Purpose: Updates the value of named attribute in the database.
' Remarks: If the id attribute is changed then the cache in the document object
'   is updated.
'===============================================================================
Private Sub updateAttribute(ByVal strName As String)
End Sub

'===============================================================================
' Name: Sub backup
' Input:
'   ByVal toBackup As Boolean - If True the current object data is stored in
' a static variables. If False, it is restored from the static storage.
' Output:
'   None
' Purpose: Backups and restores the object state.
' Remarks: Used for transaction rollback for avoiding database roundtrip.
'===============================================================================
Private Sub backup(ByVal toBackup As Boolean)
End Sub

' ==============================================================================
