/*
 * Decompiled with CFR 0.152.
 */
package favorites;

import favorites.FavoritesPlugin;
import favorites.FileTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.gui.UserKey;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;

public class FavoritesList
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    private View view = null;
    private JTree tree = null;
    private FileTreeNode root = null;
    private DefaultTreeModel treeModel = null;
    private JScrollPane scroller = null;
    private static Hashtable hash = new Hashtable();

    public FavoritesList(final View view) {
        super(new BorderLayout());
        Object object;
        this.view = view;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    FavoritesList.this.selectNode();
                }
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (ClassLoader.getSystemResource("org/gjt/sp/jedit/gui/UserKey.class") != null) {
                    int n = 3;
                    UserKey.consume((KeyEvent)keyEvent, (int)n, (int)n, (int)n, (int)n, (boolean)true);
                    if (keyEvent.isConsumed()) {
                        return;
                    }
                }
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        FavoritesList.this.selectNode();
                        if (keyEvent.isAltDown()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    view.getDockableWindowManager().showDockableWindow("favorites.dock");
                                }
                            });
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 127: {
                        FavoritesList.this.delete();
                        keyEvent.consume();
                        break;
                    }
                    case 113: {
                        FavoritesList.this.rename();
                        keyEvent.consume();
                    }
                }
            }
        };
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = FavoritesList.this.tree.getLastSelectedPathComponent();
                if (object == null) {
                    return;
                }
                view.getStatus().setMessage(object.toString());
            }
        };
        Enumeration enumeration = hash.elements();
        if (enumeration.hasMoreElements()) {
            object = (FavoritesList)enumeration.nextElement();
            this.root = ((FavoritesList)object).getRoot();
        } else {
            this.root = FavoritesPlugin.createRoot();
        }
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.addKeyListener(keyAdapter);
        this.tree.addMouseListener(mouseAdapter);
        this.tree.addTreeSelectionListener(treeSelectionListener);
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(65, 2), "none");
        this.scroller = new JScrollPane(this.tree);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("add")) {
                    FavoritesPlugin.add();
                } else if (string.equals("addGroup")) {
                    FavoritesPlugin.addGroup();
                } else if (string.equals("addBuffers")) {
                    FavoritesPlugin.addBuffers();
                } else if (string.equals("delete")) {
                    FavoritesPlugin.delete();
                }
            }
        };
        RolloverButton rolloverButton = new RolloverButton(GUIUtilities.loadIcon((String)"Plus.png"));
        rolloverButton.setActionCommand("add");
        rolloverButton.addActionListener((ActionListener)object);
        RolloverButton rolloverButton2 = new RolloverButton(GUIUtilities.loadIcon((String)"Minus.png"));
        rolloverButton2.setActionCommand("delete");
        rolloverButton2.addActionListener((ActionListener)object);
        RolloverButton rolloverButton3 = new RolloverButton(GUIUtilities.loadIcon((String)"NewDir.png"));
        rolloverButton3.setActionCommand("addGroup");
        rolloverButton3.addActionListener((ActionListener)object);
        RolloverButton rolloverButton4 = new RolloverButton(GUIUtilities.loadIcon((String)"SaveAll.png"));
        rolloverButton4.setActionCommand("addBuffers");
        rolloverButton4.addActionListener((ActionListener)object);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel.add((Component)jPanel2, "West");
        jPanel2.add((Component)rolloverButton);
        jPanel2.add((Component)rolloverButton2);
        jPanel2.add((Component)rolloverButton3);
        jPanel2.add((Component)rolloverButton4);
        this.add((Component)this.scroller, "Center");
        this.add((Component)jPanel, "North");
        hash.put(view, this);
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof BufferUpdate || eBMessage instanceof ViewUpdate || eBMessage instanceof EditPaneUpdate) {
            // empty if block
        }
    }

    public void selectNode() {
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        TreePath[] treePathArray = treeSelectionModel.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            FileTreeNode fileTreeNode = (FileTreeNode)treePathArray[i].getPathComponent(treePathArray[i].getPathCount() - 1);
            if (!fileTreeNode.isLeaf()) continue;
            jEdit.openFile((View)this.view, (String)fileTreeNode.getPath());
        }
    }

    public void reload() {
        this.treeModel.reload();
    }

    public void reload(FileTreeNode fileTreeNode) {
        this.treeModel.reload(fileTreeNode);
    }

    public static void reloadAll() {
        Enumeration enumeration = hash.elements();
        while (enumeration.hasMoreElements()) {
            ((FavoritesList)enumeration.nextElement()).reload();
        }
    }

    public static void reloadAll(FileTreeNode fileTreeNode) {
        Enumeration enumeration = hash.elements();
        while (enumeration.hasMoreElements()) {
            ((FavoritesList)enumeration.nextElement()).reload(fileTreeNode);
        }
    }

    public static FavoritesList getFavoritesList(View view) {
        return (FavoritesList)hash.get(view);
    }

    public static FavoritesList removeFavoritesList(View view) {
        return (FavoritesList)hash.remove(view);
    }

    public void addGroup() {
        String string = JOptionPane.showInputDialog((Component)this.view, "Input group name", "Add Group", 3);
        if (string == null || string.equals("")) {
            return;
        }
        FileTreeNode fileTreeNode = (FileTreeNode)this.tree.getLastSelectedPathComponent();
        if (fileTreeNode == null) {
            fileTreeNode = this.root;
        }
        if (fileTreeNode.isLeaf()) {
            fileTreeNode = (FileTreeNode)fileTreeNode.getParent();
        }
        if (fileTreeNode.add(new FileTreeNode(string))) {
            FavoritesList.reloadAll(fileTreeNode);
        }
    }

    public void add() {
        FileTreeNode fileTreeNode = (FileTreeNode)this.tree.getLastSelectedPathComponent();
        if (fileTreeNode == null) {
            fileTreeNode = this.root;
        }
        if (fileTreeNode.isLeaf()) {
            fileTreeNode = (FileTreeNode)fileTreeNode.getParent();
        }
        if (fileTreeNode.add(this.view.getBuffer())) {
            FavoritesList.reloadAll(fileTreeNode);
        }
    }

    public void addBuffers() {
        FileTreeNode fileTreeNode = (FileTreeNode)this.tree.getLastSelectedPathComponent();
        if (fileTreeNode == null) {
            fileTreeNode = this.root;
        }
        if (fileTreeNode.isLeaf()) {
            fileTreeNode = (FileTreeNode)fileTreeNode.getParent();
        }
        Buffer[] bufferArray = jEdit.getBuffers();
        boolean bl = false;
        for (int i = 0; i < bufferArray.length; ++i) {
            bl |= fileTreeNode.add(bufferArray[i]);
        }
        if (bl) {
            FavoritesList.reloadAll(fileTreeNode);
        }
    }

    public void rename() {
        FileTreeNode fileTreeNode = (FileTreeNode)this.tree.getLastSelectedPathComponent();
        if (fileTreeNode.isLeaf() || fileTreeNode.equals(this.root)) {
            return;
        }
        String string = JOptionPane.showInputDialog((Component)this.view, "Input group name", "Rename Group", 3);
        if (string == null || string.equals("")) {
            return;
        }
        FileTreeNode fileTreeNode2 = (FileTreeNode)fileTreeNode.getParent();
        if (fileTreeNode2 == null) {
            return;
        }
        if (fileTreeNode2.renameGroup(fileTreeNode, string)) {
            FavoritesList.reloadAll(fileTreeNode2);
        }
    }

    public void delete() {
        if (JOptionPane.showConfirmDialog((Component)this.view, "Do you want to delete?", "Delete favorites", 0) != 0) {
            return;
        }
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        TreePath[] treePathArray = treeSelectionModel.getSelectionPaths();
        FileTreeNode fileTreeNode = null;
        TreePath treePath = null;
        for (int i = 0; i < treePathArray.length; ++i) {
            FileTreeNode fileTreeNode2 = (FileTreeNode)treePathArray[i].getPathComponent(treePathArray[i].getPathCount() - 1);
            fileTreeNode = (FileTreeNode)fileTreeNode2.getParent();
            treePath = treePathArray[i].getParentPath();
            if (fileTreeNode == null) continue;
            fileTreeNode.delete(fileTreeNode2);
        }
        if (treePathArray.length == 1 && fileTreeNode != null) {
            FavoritesList.reloadAll(fileTreeNode);
        } else {
            FavoritesList.reloadAll();
        }
        if (treePath != null) {
            treeSelectionModel.setSelectionPath(treePath);
        }
    }

    public void focusOnDefaultComponent() {
        if (this.tree != null) {
            this.tree.requestFocus();
        }
    }

    public FileTreeNode getRoot() {
        return this.root;
    }

    public FileTreeNode getHistory() {
        return (FileTreeNode)this.root.getChild(FavoritesPlugin.getHistoryKey());
    }
}

