/*
 * Decompiled with CFR 0.152.
 */
package favorites;

import favorites.FavoritesList;
import favorites.FileTreeNode;
import favorites.FileTreeNodeForHistory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class FavoritesPlugin
extends EBPlugin {
    private FavoritesList lastList = null;
    static /* synthetic */ Class class$favorites$FavoritesPlugin;

    public void handleMessage(EBMessage eBMessage) {
        BufferUpdate bufferUpdate;
        if (eBMessage instanceof BufferUpdate && (bufferUpdate = (BufferUpdate)eBMessage).getWhat().equals(BufferUpdate.CLOSED)) {
            if (bufferUpdate.getView() == null) {
                return;
            }
            FavoritesPlugin.reloadHistory(bufferUpdate.getView());
        }
        if (eBMessage instanceof ViewUpdate && (bufferUpdate = (ViewUpdate)eBMessage).getWhat().equals(ViewUpdate.CLOSED)) {
            this.lastList = FavoritesList.removeFavoritesList((View)eBMessage.getSource());
        }
    }

    public static String getHistoryKey() {
        return "# Recent Files";
    }

    public static void reloadHistory(View view) {
        final FavoritesList favoritesList = FavoritesList.getFavoritesList(view);
        if (favoritesList == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileTreeNode fileTreeNode = favoritesList.getRoot();
                FileTreeNode fileTreeNode2 = favoritesList.getHistory();
                boolean bl = fileTreeNode2 == null;
                fileTreeNode.delete(fileTreeNode2);
                fileTreeNode2 = FavoritesPlugin.loadHistory();
                fileTreeNode.add(fileTreeNode2);
                if (bl) {
                    FavoritesList.reloadAll();
                } else {
                    FavoritesList.reloadAll(fileTreeNode2);
                }
            }
        });
    }

    public void stop() {
        FavoritesPlugin.saveXML(this.lastList);
    }

    public static void add() {
        View view = jEdit.getActiveView();
        FavoritesList favoritesList = FavoritesList.getFavoritesList(view);
        if (favoritesList != null) {
            favoritesList.add();
            FavoritesPlugin.saveXML();
        }
    }

    public static void delete() {
        View view = jEdit.getActiveView();
        FavoritesList favoritesList = FavoritesList.getFavoritesList(view);
        if (favoritesList != null) {
            favoritesList.delete();
            FavoritesPlugin.saveXML();
        }
    }

    public static void addGroup() {
        View view = jEdit.getActiveView();
        FavoritesList favoritesList = FavoritesList.getFavoritesList(view);
        if (favoritesList != null) {
            favoritesList.addGroup();
            FavoritesPlugin.saveXML();
        }
    }

    public static void addBuffers() {
        View view = jEdit.getActiveView();
        FavoritesList favoritesList = FavoritesList.getFavoritesList(view);
        if (favoritesList != null) {
            favoritesList.addBuffers();
            FavoritesPlugin.saveXML();
        }
    }

    private static FileTreeNode loadHistory() {
        FileTreeNode fileTreeNode = null;
        List list = BufferHistory.getHistory();
        BufferHistory.Entry entry = null;
        fileTreeNode = new FileTreeNode(FavoritesPlugin.getHistoryKey());
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            entry = (BufferHistory.Entry)iterator.next();
            fileTreeNode.add(new FileTreeNodeForHistory(MiscUtilities.getFileName((String)entry.path), entry.path, n++));
        }
        return fileTreeNode;
    }

    public static FileTreeNode createRoot() {
        FileTreeNode fileTreeNode = FavoritesPlugin.loadXML();
        if (fileTreeNode == null) {
            fileTreeNode = new FileTreeNode("root");
        }
        fileTreeNode.add(FavoritesPlugin.loadHistory());
        return fileTreeNode;
    }

    private static FileTreeNode loadXML() {
        String string = MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)"favorites");
        FileTreeNode fileTreeNode = null;
        File file = null;
        try {
            file = new File(string, "favorites.xml");
            if (!file.exists()) {
                return fileTreeNode;
            }
        }
        catch (Exception exception) {
            Log.log((int)9, (Object)(class$favorites$FavoritesPlugin == null ? (class$favorites$FavoritesPlugin = FavoritesPlugin.class$("favorites.FavoritesPlugin")) : class$favorites$FavoritesPlugin), (Object)exception);
            return fileTreeNode;
        }
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            FavoritesXmlHandler favoritesXmlHandler = new FavoritesXmlHandler();
            sAXParser.parse(file, (DefaultHandler)favoritesXmlHandler);
            fileTreeNode = favoritesXmlHandler.getRoot();
        }
        catch (Exception exception) {
            Log.log((int)9, (Object)(class$favorites$FavoritesPlugin == null ? (class$favorites$FavoritesPlugin = FavoritesPlugin.class$("favorites.FavoritesPlugin")) : class$favorites$FavoritesPlugin), (Object)exception);
        }
        return fileTreeNode;
    }

    private static void saveXML() {
        View view = jEdit.getActiveView();
        FavoritesList favoritesList = FavoritesList.getFavoritesList(view);
        if (favoritesList == null) {
            return;
        }
        FavoritesPlugin.saveXML(favoritesList);
    }

    private static void saveXML(FavoritesList favoritesList) {
        if (favoritesList == null) {
            return;
        }
        FileTreeNode fileTreeNode = (FileTreeNode)favoritesList.getRoot().clone();
        fileTreeNode.delete(favoritesList.getHistory());
        String string = MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)"favorites");
        BufferedWriter bufferedWriter = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(string, "favorites.xml")), "UTF-8"));
        }
        catch (Exception exception) {
            Log.log((int)9, (Object)(class$favorites$FavoritesPlugin == null ? (class$favorites$FavoritesPlugin = FavoritesPlugin.class$("favorites.FavoritesPlugin")) : class$favorites$FavoritesPlugin), (Object)exception);
            return;
        }
        FavoritesPlugin.saveFavorites(bufferedWriter, fileTreeNode, true);
        try {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        catch (Exception exception) {
            Log.log((int)9, (Object)(class$favorites$FavoritesPlugin == null ? (class$favorites$FavoritesPlugin = FavoritesPlugin.class$("favorites.FavoritesPlugin")) : class$favorites$FavoritesPlugin), (Object)exception);
        }
    }

    private static boolean saveFavorites(BufferedWriter bufferedWriter, FileTreeNode fileTreeNode, boolean bl) {
        boolean bl2 = false;
        try {
            if (bl) {
                bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("<GROUP name=\"");
            bufferedWriter.write(fileTreeNode.getName());
            bufferedWriter.write("\">");
            bufferedWriter.newLine();
            Enumeration enumeration = fileTreeNode.children();
            while (enumeration.hasMoreElements()) {
                FileTreeNode fileTreeNode2 = (FileTreeNode)enumeration.nextElement();
                if (fileTreeNode2.isLeaf()) {
                    bufferedWriter.write("  <FILE path=\"");
                    String string = fileTreeNode2.getPath();
                    string = string.replace('\\', '/');
                    bufferedWriter.write(string);
                    bufferedWriter.write("\"  name=\"");
                    bufferedWriter.write(fileTreeNode2.getName());
                    bufferedWriter.write("\"/>");
                    bufferedWriter.newLine();
                    continue;
                }
                FavoritesPlugin.saveFavorites(bufferedWriter, fileTreeNode2, false);
            }
            bufferedWriter.write("</GROUP>");
            bufferedWriter.newLine();
            bl2 = true;
        }
        catch (Exception exception) {
            Log.log((int)9, (Object)(class$favorites$FavoritesPlugin == null ? (class$favorites$FavoritesPlugin = FavoritesPlugin.class$("favorites.FavoritesPlugin")) : class$favorites$FavoritesPlugin), (Object)exception);
        }
        return bl2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FavoritesXmlHandler
    extends DefaultHandler {
        FileTreeNode node = null;

        private FavoritesXmlHandler() {
        }

        public FileTreeNode getRoot() {
            return this.node;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("GROUP".equals(string3)) {
                String string4 = attributes.getValue("name");
                if (string4 == null) {
                    return;
                }
                FileTreeNode fileTreeNode = new FileTreeNode(string4);
                if (this.node != null) {
                    this.node.add(fileTreeNode);
                }
                this.node = fileTreeNode;
            } else if ("FILE".equals(string3)) {
                String string5 = attributes.getValue("name");
                if (string5 == null) {
                    return;
                }
                String string6 = attributes.getValue("path");
                if (string6 == null) {
                    return;
                }
                FileTreeNode fileTreeNode = new FileTreeNode(string5, string6);
                if (this.node != null) {
                    this.node.add(fileTreeNode);
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) {
        }

        public void endElement(String string, String string2, String string3) {
            if ("GROUP".equals(string3) && this.node != null && this.node.getParent() != null) {
                this.node = (FileTreeNode)this.node.getParent();
            }
        }
    }
}

