/*
 * Decompiled with CFR 0.152.
 */
package favorites;

import favorites.VectorHash;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.gjt.sp.jedit.Buffer;

public class FileTreeNode
implements TreeNode,
Comparable,
Cloneable {
    private String name;
    private String path;
    private VectorHash children = new VectorHash();
    private boolean leaf;
    private TreeNode parent;
    public static String TYPE_FILE = "File";
    public static String TYPE_DIRECTORY = "Directory";
    private String type;

    public FileTreeNode(String string, String string2, String string3) {
        this.name = string;
        this.path = string2.replace('\\', '/');
        this.type = string3;
        this.leaf = true;
    }

    public FileTreeNode(String string, String string2) {
        this(string, string2, TYPE_FILE);
    }

    public FileTreeNode(String string) {
        this(string, "");
        this.leaf = false;
    }

    public boolean renameGroup(FileTreeNode fileTreeNode, String string) {
        if (fileTreeNode.isLeaf()) {
            return false;
        }
        if (this.children.containsKey(string)) {
            return false;
        }
        if (!this.children.containsKey(fileTreeNode.getKey())) {
            return false;
        }
        int n = this.children.getIndex(fileTreeNode.getKey());
        this.children.remove(fileTreeNode.getKey());
        fileTreeNode.setName(string);
        this.children.insert(fileTreeNode.getKey(), fileTreeNode, n);
        return true;
    }

    public boolean add(FileTreeNode fileTreeNode) {
        if (this.children.containsKey(fileTreeNode.getKey())) {
            return false;
        }
        fileTreeNode.setParent(this);
        int n = 0;
        for (n = 0; n < this.children.size() && fileTreeNode.compareTo(this.children.get(n)) > 0; ++n) {
        }
        this.children.insert(fileTreeNode.getKey(), fileTreeNode, n);
        return true;
    }

    public boolean add(Buffer buffer) {
        return this.add(new FileTreeNode(buffer.getName(), buffer.getPath()));
    }

    public boolean addPathNode(String string) {
        return this.add(new FileTreeNode("", string, TYPE_DIRECTORY));
    }

    public void delete(FileTreeNode fileTreeNode) {
        if (fileTreeNode == null) {
            return;
        }
        this.children.remove(fileTreeNode.getKey());
    }

    public void setParent(FileTreeNode fileTreeNode) {
        this.parent = fileTreeNode;
    }

    public Enumeration children() {
        return this.children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.leaf;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return (TreeNode)this.children.get(n);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (!(treeNode instanceof FileTreeNode)) {
            return -1;
        }
        return this.children.getIndex(((FileTreeNode)treeNode).getKey());
    }

    public TreeNode getChild(Object object) {
        return (TreeNode)this.children.get(object);
    }

    @Override
    public TreeNode getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return null;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    public String toString() {
        if (this.isLeaf()) {
            return this.name + " (" + this.path + ")";
        }
        return this.name;
    }

    public String getKey() {
        if (this.isLeaf()) {
            return this.path;
        }
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public int compareTo(Object object) {
        if (!(object instanceof FileTreeNode)) {
            return 0;
        }
        FileTreeNode fileTreeNode = (FileTreeNode)object;
        if (this.isLeaf() && !fileTreeNode.isLeaf()) {
            return 1;
        }
        if (!this.isLeaf() && fileTreeNode.isLeaf()) {
            return -1;
        }
        if (TYPE_DIRECTORY.equals(this.getType()) && !TYPE_DIRECTORY.equals(fileTreeNode.getType())) {
            return -1;
        }
        if (!TYPE_DIRECTORY.equals(this.getType()) && TYPE_DIRECTORY.equals(fileTreeNode.getType())) {
            return 1;
        }
        return this.toString().compareToIgnoreCase(fileTreeNode.toString());
    }

    public Object clone() {
        FileTreeNode fileTreeNode = null;
        try {
            fileTreeNode = (FileTreeNode)super.clone();
            fileTreeNode.children = (VectorHash)fileTreeNode.children.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileTreeNode;
    }
}

