/*
 * Decompiled with CFR 0.152.
 */
package favorites;

import favorites.FavoritesPlugin;
import favorites.FileTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.gui.UserKey;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;

public class FavoritesList
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    private View view = null;
    private JTree tree = null;
    private FileTreeNode root = null;
    private DefaultTreeModel treeModel = null;
    private JScrollPane scroller = null;
    private static Hashtable hash = new Hashtable();

    public FavoritesList(final View view) {
        super(new BorderLayout());
        this.view = view;
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    FavoritesList.this.selectNode();
                }
            }
        };
        KeyAdapter kl = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ClassLoader.getSystemResource("org/gjt/sp/jedit/gui/UserKey.class") != null) {
                    int mod = 3;
                    UserKey.consume((KeyEvent)e, (int)mod, (int)mod, (int)mod, (int)mod, (boolean)true);
                    if (e.isConsumed()) {
                        return;
                    }
                }
                switch (e.getKeyCode()) {
                    case 10: {
                        FavoritesList.this.selectNode();
                        if (e.isAltDown()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    view.getDockableWindowManager().showDockableWindow("favorites.dock");
                                }
                            });
                        }
                        e.consume();
                        break;
                    }
                    case 127: {
                        FavoritesList.this.delete();
                        e.consume();
                        break;
                    }
                    case 113: {
                        FavoritesList.this.rename();
                        e.consume();
                    }
                }
            }
        };
        TreeSelectionListener tsl = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                Object node = FavoritesList.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                view.getStatus().setMessage(node.toString());
            }
        };
        Enumeration element = hash.elements();
        if (element.hasMoreElements()) {
            FavoritesList list = (FavoritesList)element.nextElement();
            this.root = list.getRoot();
        } else {
            this.root = FavoritesPlugin.createRoot();
        }
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.addKeyListener(kl);
        this.tree.addMouseListener(ml);
        this.tree.addTreeSelectionListener(tsl);
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(65, 2), "none");
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (leaf && value instanceof FileTreeNode && c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    FileTreeNode node = (FileTreeNode)value;
                    if (FileTreeNode.TYPE_DIRECTORY.equals(node.getType())) {
                        label.setIcon(GUIUtilities.loadIcon((String)"Folder.png"));
                    }
                }
                return c;
            }
        });
        this.scroller = new JScrollPane(this.tree);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals("add")) {
                    FavoritesPlugin.add();
                } else if (cmd.equals("addParentPath")) {
                    FavoritesPlugin.addParentPath();
                } else if (cmd.equals("addGroup")) {
                    FavoritesPlugin.addGroup();
                } else if (cmd.equals("addBuffers")) {
                    FavoritesPlugin.addBuffers();
                } else if (cmd.equals("delete")) {
                    FavoritesPlugin.delete();
                }
            }
        };
        RolloverButton addButton = new RolloverButton(GUIUtilities.loadIcon((String)"Plus.png"));
        addButton.setActionCommand("add");
        addButton.addActionListener(al);
        RolloverButton deleteButton = new RolloverButton(GUIUtilities.loadIcon((String)"Minus.png"));
        deleteButton.setActionCommand("delete");
        deleteButton.addActionListener(al);
        RolloverButton addPathButton = new RolloverButton(GUIUtilities.loadIcon((String)"CurrentDir.png"));
        addPathButton.setActionCommand("addParentPath");
        addPathButton.addActionListener(al);
        RolloverButton addGroupButton = new RolloverButton(GUIUtilities.loadIcon((String)"NewDir.png"));
        addGroupButton.setActionCommand("addGroup");
        addGroupButton.addActionListener(al);
        RolloverButton addBuffersButton = new RolloverButton(GUIUtilities.loadIcon((String)"SaveAll.png"));
        addBuffersButton.setActionCommand("addBuffers");
        addBuffersButton.addActionListener(al);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel leftPanel = new JPanel(new FlowLayout());
        panel.add((Component)leftPanel, "West");
        leftPanel.add((Component)addButton);
        leftPanel.add((Component)deleteButton);
        leftPanel.add((Component)addPathButton);
        leftPanel.add((Component)addGroupButton);
        leftPanel.add((Component)addBuffersButton);
        this.add((Component)this.scroller, "Center");
        this.add((Component)panel, "North");
        hash.put(view, this);
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof BufferUpdate || message instanceof ViewUpdate || message instanceof EditPaneUpdate) {
            // empty if block
        }
    }

    public void selectNode() {
        TreeSelectionModel selmodel = this.tree.getSelectionModel();
        TreePath[] tp = selmodel.getSelectionPaths();
        for (int i = 0; i < tp.length; ++i) {
            FileTreeNode node = (FileTreeNode)tp[i].getPathComponent(tp[i].getPathCount() - 1);
            if (!node.isLeaf()) continue;
            if (FileTreeNode.TYPE_DIRECTORY.equals(node.getType())) {
                VFSBrowser.browseDirectory((View)this.view, (String)node.getPath());
                continue;
            }
            jEdit.openFile((View)this.view, (String)node.getPath());
        }
    }

    public void reload() {
        this.treeModel.reload();
    }

    public void reload(FileTreeNode node) {
        this.treeModel.reload(node);
    }

    public static void reloadAll() {
        Enumeration element = hash.elements();
        while (element.hasMoreElements()) {
            ((FavoritesList)element.nextElement()).reload();
        }
    }

    public static void reloadAll(FileTreeNode node) {
        Enumeration element = hash.elements();
        while (element.hasMoreElements()) {
            ((FavoritesList)element.nextElement()).reload(node);
        }
    }

    public static FavoritesList getFavoritesList(View view) {
        return (FavoritesList)hash.get(view);
    }

    public static FavoritesList removeFavoritesList(View view) {
        return (FavoritesList)hash.remove(view);
    }

    public void addGroup() {
        String gname = JOptionPane.showInputDialog((Component)this.view, "Input group name", "Add Group", 3);
        if (gname == null || gname.equals("")) {
            return;
        }
        FileTreeNode node = (FileTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            node = this.root;
        }
        if (node.isLeaf()) {
            node = (FileTreeNode)node.getParent();
        }
        if (node.addNode(new FileTreeNode(gname))) {
            FavoritesList.reloadAll(node);
        }
    }

    public void addPath() {
        String path = JOptionPane.showInputDialog((Component)this.view, "Input Path", "Add Path", 3);
        if (path == null || path.equals("")) {
            return;
        }
        FileTreeNode node = (FileTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            node = this.root;
        }
        if (node.isLeaf()) {
            node = (FileTreeNode)node.getParent();
        }
        if (node.addNode(path, FileTreeNode.TYPE_DIRECTORY)) {
            FavoritesList.reloadAll(node);
        }
    }

    public void addParentPath() {
        FileTreeNode node = (FileTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            node = this.root;
        }
        if (node.isLeaf()) {
            node = (FileTreeNode)node.getParent();
        }
        String path = this.view.getBuffer().getPath();
        if (node.addNode(path = MiscUtilities.getParentOfPath((String)path), FileTreeNode.TYPE_DIRECTORY)) {
            FavoritesList.reloadAll(node);
        }
    }

    public void add() {
        FileTreeNode node = (FileTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            node = this.root;
        }
        if (node.isLeaf()) {
            node = (FileTreeNode)node.getParent();
        }
        if (node.addNode(this.view.getBuffer())) {
            FavoritesList.reloadAll(node);
        }
    }

    public void addBuffers() {
        FileTreeNode node = (FileTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            node = this.root;
        }
        if (node.isLeaf()) {
            node = (FileTreeNode)node.getParent();
        }
        Buffer[] buffers = jEdit.getBuffers();
        boolean result = false;
        for (int i = 0; i < buffers.length; ++i) {
            result |= node.addNode(buffers[i]);
        }
        if (result) {
            FavoritesList.reloadAll(node);
        }
    }

    public void rename() {
        FileTreeNode node = (FileTreeNode)this.tree.getLastSelectedPathComponent();
        if (node.isLeaf() || node.equals(this.root)) {
            return;
        }
        String gname = JOptionPane.showInputDialog((Component)this.view, "Input group name", "Rename Group", 3);
        if (gname == null || gname.equals("")) {
            return;
        }
        FileTreeNode parent = (FileTreeNode)node.getParent();
        if (parent == null) {
            return;
        }
        if (parent.renameGroup(node, gname)) {
            FavoritesList.reloadAll(parent);
        }
    }

    public void delete() {
        if (JOptionPane.showConfirmDialog((Component)this.view, "Do you want to delete?", "Delete favorites", 0) != 0) {
            return;
        }
        TreeSelectionModel selmodel = this.tree.getSelectionModel();
        TreePath[] tp = selmodel.getSelectionPaths();
        FileTreeNode parent = null;
        TreePath parentPath = null;
        for (int i = 0; i < tp.length; ++i) {
            FileTreeNode node = (FileTreeNode)tp[i].getPathComponent(tp[i].getPathCount() - 1);
            parent = (FileTreeNode)node.getParent();
            parentPath = tp[i].getParentPath();
            if (parent == null) continue;
            parent.deleteNode(node);
        }
        if (tp.length == 1 && parent != null) {
            FavoritesList.reloadAll(parent);
        } else {
            FavoritesList.reloadAll();
        }
        if (parentPath != null) {
            selmodel.setSelectionPath(parentPath);
        }
    }

    public void focusOnDefaultComponent() {
        if (this.tree != null) {
            this.tree.requestFocus();
        }
    }

    public FileTreeNode getRoot() {
        return this.root;
    }

    public FileTreeNode getHistory() {
        return (FileTreeNode)this.root.getChild(FavoritesPlugin.getHistoryKey());
    }
}

